/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;

@UaDataType(value="DataChangeFilter")
public class DataChangeFilter
extends MonitoringFilter {
    public static final NodeId TypeId = Identifiers.DataChangeFilter;
    public static final NodeId BinaryEncodingId = Identifiers.DataChangeFilter_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DataChangeFilter_Encoding_DefaultXml;
    protected final DataChangeTrigger _trigger;
    protected final UInteger _deadbandType;
    protected final Double _deadbandValue;

    public DataChangeFilter() {
        this._trigger = null;
        this._deadbandType = null;
        this._deadbandValue = null;
    }

    public DataChangeFilter(DataChangeTrigger _trigger, UInteger _deadbandType, Double _deadbandValue) {
        this._trigger = _trigger;
        this._deadbandType = _deadbandType;
        this._deadbandValue = _deadbandValue;
    }

    public DataChangeTrigger getTrigger() {
        return this._trigger;
    }

    public UInteger getDeadbandType() {
        return this._deadbandType;
    }

    public Double getDeadbandValue() {
        return this._deadbandValue;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Trigger", (Object)this._trigger).add("DeadbandType", (Object)this._deadbandType).add("DeadbandValue", (Object)this._deadbandValue).toString();
    }

    public static void encode(DataChangeFilter dataChangeFilter, UaEncoder encoder) {
        encoder.encodeEnumeration("Trigger", dataChangeFilter._trigger);
        encoder.encodeUInt32("DeadbandType", dataChangeFilter._deadbandType);
        encoder.encodeDouble("DeadbandValue", dataChangeFilter._deadbandValue);
    }

    public static DataChangeFilter decode(UaDecoder decoder) {
        DataChangeTrigger _trigger = decoder.decodeEnumeration("Trigger", DataChangeTrigger.class);
        UInteger _deadbandType = decoder.decodeUInt32("DeadbandType");
        Double _deadbandValue = decoder.decodeDouble("DeadbandValue");
        return new DataChangeFilter(_trigger, _deadbandType, _deadbandValue);
    }

    static {
        DelegateRegistry.registerEncoder(DataChangeFilter::encode, DataChangeFilter.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(DataChangeFilter::decode, DataChangeFilter.class, BinaryEncodingId, XmlEncodingId);
    }
}

