/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

@UaDataType(value="CreateSessionRequest")
public class CreateSessionRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.CreateSessionRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CreateSessionRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CreateSessionRequest_Encoding_DefaultXml;
    protected final RequestHeader _requestHeader;
    protected final ApplicationDescription _clientDescription;
    protected final String _serverUri;
    protected final String _endpointUrl;
    protected final String _sessionName;
    protected final ByteString _clientNonce;
    protected final ByteString _clientCertificate;
    protected final Double _requestedSessionTimeout;
    protected final UInteger _maxResponseMessageSize;

    public CreateSessionRequest() {
        this._requestHeader = null;
        this._clientDescription = null;
        this._serverUri = null;
        this._endpointUrl = null;
        this._sessionName = null;
        this._clientNonce = null;
        this._clientCertificate = null;
        this._requestedSessionTimeout = null;
        this._maxResponseMessageSize = null;
    }

    public CreateSessionRequest(RequestHeader _requestHeader, ApplicationDescription _clientDescription, String _serverUri, String _endpointUrl, String _sessionName, ByteString _clientNonce, ByteString _clientCertificate, Double _requestedSessionTimeout, UInteger _maxResponseMessageSize) {
        this._requestHeader = _requestHeader;
        this._clientDescription = _clientDescription;
        this._serverUri = _serverUri;
        this._endpointUrl = _endpointUrl;
        this._sessionName = _sessionName;
        this._clientNonce = _clientNonce;
        this._clientCertificate = _clientCertificate;
        this._requestedSessionTimeout = _requestedSessionTimeout;
        this._maxResponseMessageSize = _maxResponseMessageSize;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this._requestHeader;
    }

    public ApplicationDescription getClientDescription() {
        return this._clientDescription;
    }

    public String getServerUri() {
        return this._serverUri;
    }

    public String getEndpointUrl() {
        return this._endpointUrl;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public ByteString getClientNonce() {
        return this._clientNonce;
    }

    public ByteString getClientCertificate() {
        return this._clientCertificate;
    }

    public Double getRequestedSessionTimeout() {
        return this._requestedSessionTimeout;
    }

    public UInteger getMaxResponseMessageSize() {
        return this._maxResponseMessageSize;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this._requestHeader).add("ClientDescription", (Object)this._clientDescription).add("ServerUri", (Object)this._serverUri).add("EndpointUrl", (Object)this._endpointUrl).add("SessionName", (Object)this._sessionName).add("ClientNonce", (Object)this._clientNonce).add("ClientCertificate", (Object)this._clientCertificate).add("RequestedSessionTimeout", (Object)this._requestedSessionTimeout).add("MaxResponseMessageSize", (Object)this._maxResponseMessageSize).toString();
    }

    public static void encode(CreateSessionRequest createSessionRequest, UaEncoder encoder) {
        encoder.encodeSerializable("RequestHeader", createSessionRequest._requestHeader != null ? createSessionRequest._requestHeader : new RequestHeader());
        encoder.encodeSerializable("ClientDescription", createSessionRequest._clientDescription != null ? createSessionRequest._clientDescription : new ApplicationDescription());
        encoder.encodeString("ServerUri", createSessionRequest._serverUri);
        encoder.encodeString("EndpointUrl", createSessionRequest._endpointUrl);
        encoder.encodeString("SessionName", createSessionRequest._sessionName);
        encoder.encodeByteString("ClientNonce", createSessionRequest._clientNonce);
        encoder.encodeByteString("ClientCertificate", createSessionRequest._clientCertificate);
        encoder.encodeDouble("RequestedSessionTimeout", createSessionRequest._requestedSessionTimeout);
        encoder.encodeUInt32("MaxResponseMessageSize", createSessionRequest._maxResponseMessageSize);
    }

    public static CreateSessionRequest decode(UaDecoder decoder) {
        RequestHeader _requestHeader = decoder.decodeSerializable("RequestHeader", RequestHeader.class);
        ApplicationDescription _clientDescription = decoder.decodeSerializable("ClientDescription", ApplicationDescription.class);
        String _serverUri = decoder.decodeString("ServerUri");
        String _endpointUrl = decoder.decodeString("EndpointUrl");
        String _sessionName = decoder.decodeString("SessionName");
        ByteString _clientNonce = decoder.decodeByteString("ClientNonce");
        ByteString _clientCertificate = decoder.decodeByteString("ClientCertificate");
        Double _requestedSessionTimeout = decoder.decodeDouble("RequestedSessionTimeout");
        UInteger _maxResponseMessageSize = decoder.decodeUInt32("MaxResponseMessageSize");
        return new CreateSessionRequest(_requestHeader, _clientDescription, _serverUri, _endpointUrl, _sessionName, _clientNonce, _clientCertificate, _requestedSessionTimeout, _maxResponseMessageSize);
    }

    static {
        DelegateRegistry.registerEncoder(CreateSessionRequest::encode, CreateSessionRequest.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(CreateSessionRequest::decode, CreateSessionRequest.class, BinaryEncodingId, XmlEncodingId);
    }
}

