/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;

@UaDataType(value="ContentFilterResult")
public class ContentFilterResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ContentFilterResult;
    public static final NodeId BinaryEncodingId = Identifiers.ContentFilterResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ContentFilterResult_Encoding_DefaultXml;
    protected final ContentFilterElementResult[] _elementResults;
    protected final DiagnosticInfo[] _elementDiagnosticInfos;

    public ContentFilterResult() {
        this._elementResults = null;
        this._elementDiagnosticInfos = null;
    }

    public ContentFilterResult(ContentFilterElementResult[] _elementResults, DiagnosticInfo[] _elementDiagnosticInfos) {
        this._elementResults = _elementResults;
        this._elementDiagnosticInfos = _elementDiagnosticInfos;
    }

    @Nullable
    public ContentFilterElementResult[] getElementResults() {
        return this._elementResults;
    }

    @Nullable
    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this._elementDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ElementResults", (Object)this._elementResults).add("ElementDiagnosticInfos", (Object)this._elementDiagnosticInfos).toString();
    }

    public static void encode(ContentFilterResult contentFilterResult, UaEncoder encoder) {
        encoder.encodeArray("ElementResults", contentFilterResult._elementResults, encoder::encodeSerializable);
        encoder.encodeArray("ElementDiagnosticInfos", contentFilterResult._elementDiagnosticInfos, encoder::encodeDiagnosticInfo);
    }

    public static ContentFilterResult decode(UaDecoder decoder) {
        ContentFilterElementResult[] _elementResults = decoder.decodeArray("ElementResults", decoder::decodeSerializable, ContentFilterElementResult.class);
        DiagnosticInfo[] _elementDiagnosticInfos = decoder.decodeArray("ElementDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        return new ContentFilterResult(_elementResults, _elementDiagnosticInfos);
    }

    static {
        DelegateRegistry.registerEncoder(ContentFilterResult::encode, ContentFilterResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ContentFilterResult::decode, ContentFilterResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

