/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

@UaDataType(value="ContentFilterElementResult")
public class ContentFilterElementResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ContentFilterElementResult;
    public static final NodeId BinaryEncodingId = Identifiers.ContentFilterElementResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ContentFilterElementResult_Encoding_DefaultXml;
    protected final StatusCode _statusCode;
    protected final StatusCode[] _operandStatusCodes;
    protected final DiagnosticInfo[] _operandDiagnosticInfos;

    public ContentFilterElementResult() {
        this._statusCode = null;
        this._operandStatusCodes = null;
        this._operandDiagnosticInfos = null;
    }

    public ContentFilterElementResult(StatusCode _statusCode, StatusCode[] _operandStatusCodes, DiagnosticInfo[] _operandDiagnosticInfos) {
        this._statusCode = _statusCode;
        this._operandStatusCodes = _operandStatusCodes;
        this._operandDiagnosticInfos = _operandDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this._statusCode;
    }

    @Nullable
    public StatusCode[] getOperandStatusCodes() {
        return this._operandStatusCodes;
    }

    @Nullable
    public DiagnosticInfo[] getOperandDiagnosticInfos() {
        return this._operandDiagnosticInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this._statusCode).add("OperandStatusCodes", (Object)this._operandStatusCodes).add("OperandDiagnosticInfos", (Object)this._operandDiagnosticInfos).toString();
    }

    public static void encode(ContentFilterElementResult contentFilterElementResult, UaEncoder encoder) {
        encoder.encodeStatusCode("StatusCode", contentFilterElementResult._statusCode);
        encoder.encodeArray("OperandStatusCodes", contentFilterElementResult._operandStatusCodes, encoder::encodeStatusCode);
        encoder.encodeArray("OperandDiagnosticInfos", contentFilterElementResult._operandDiagnosticInfos, encoder::encodeDiagnosticInfo);
    }

    public static ContentFilterElementResult decode(UaDecoder decoder) {
        StatusCode _statusCode = decoder.decodeStatusCode("StatusCode");
        StatusCode[] _operandStatusCodes = decoder.decodeArray("OperandStatusCodes", decoder::decodeStatusCode, StatusCode.class);
        DiagnosticInfo[] _operandDiagnosticInfos = decoder.decodeArray("OperandDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        return new ContentFilterElementResult(_statusCode, _operandStatusCodes, _operandDiagnosticInfos);
    }

    static {
        DelegateRegistry.registerEncoder(ContentFilterElementResult::encode, ContentFilterElementResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ContentFilterElementResult::decode, ContentFilterElementResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

