/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="ChannelSecurityToken")
public class ChannelSecurityToken
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ChannelSecurityToken;
    public static final NodeId BinaryEncodingId = Identifiers.ChannelSecurityToken_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ChannelSecurityToken_Encoding_DefaultXml;
    protected final UInteger _channelId;
    protected final UInteger _tokenId;
    protected final DateTime _createdAt;
    protected final UInteger _revisedLifetime;

    public ChannelSecurityToken() {
        this._channelId = null;
        this._tokenId = null;
        this._createdAt = null;
        this._revisedLifetime = null;
    }

    public ChannelSecurityToken(UInteger _channelId, UInteger _tokenId, DateTime _createdAt, UInteger _revisedLifetime) {
        this._channelId = _channelId;
        this._tokenId = _tokenId;
        this._createdAt = _createdAt;
        this._revisedLifetime = _revisedLifetime;
    }

    public UInteger getChannelId() {
        return this._channelId;
    }

    public UInteger getTokenId() {
        return this._tokenId;
    }

    public DateTime getCreatedAt() {
        return this._createdAt;
    }

    public UInteger getRevisedLifetime() {
        return this._revisedLifetime;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ChannelId", (Object)this._channelId).add("TokenId", (Object)this._tokenId).add("CreatedAt", (Object)this._createdAt).add("RevisedLifetime", (Object)this._revisedLifetime).toString();
    }

    public static void encode(ChannelSecurityToken channelSecurityToken, UaEncoder encoder) {
        encoder.encodeUInt32("ChannelId", channelSecurityToken._channelId);
        encoder.encodeUInt32("TokenId", channelSecurityToken._tokenId);
        encoder.encodeDateTime("CreatedAt", channelSecurityToken._createdAt);
        encoder.encodeUInt32("RevisedLifetime", channelSecurityToken._revisedLifetime);
    }

    public static ChannelSecurityToken decode(UaDecoder decoder) {
        UInteger _channelId = decoder.decodeUInt32("ChannelId");
        UInteger _tokenId = decoder.decodeUInt32("TokenId");
        DateTime _createdAt = decoder.decodeDateTime("CreatedAt");
        UInteger _revisedLifetime = decoder.decodeUInt32("RevisedLifetime");
        return new ChannelSecurityToken(_channelId, _tokenId, _createdAt, _revisedLifetime);
    }

    static {
        DelegateRegistry.registerEncoder(ChannelSecurityToken::encode, ChannelSecurityToken.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ChannelSecurityToken::decode, ChannelSecurityToken.class, BinaryEncodingId, XmlEncodingId);
    }
}

