/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="BrowsePathTarget")
public class BrowsePathTarget
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowsePathTarget;
    public static final NodeId BinaryEncodingId = Identifiers.BrowsePathTarget_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowsePathTarget_Encoding_DefaultXml;
    protected final ExpandedNodeId _targetId;
    protected final UInteger _remainingPathIndex;

    public BrowsePathTarget() {
        this._targetId = null;
        this._remainingPathIndex = null;
    }

    public BrowsePathTarget(ExpandedNodeId _targetId, UInteger _remainingPathIndex) {
        this._targetId = _targetId;
        this._remainingPathIndex = _remainingPathIndex;
    }

    public ExpandedNodeId getTargetId() {
        return this._targetId;
    }

    public UInteger getRemainingPathIndex() {
        return this._remainingPathIndex;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("TargetId", (Object)this._targetId).add("RemainingPathIndex", (Object)this._remainingPathIndex).toString();
    }

    public static void encode(BrowsePathTarget browsePathTarget, UaEncoder encoder) {
        encoder.encodeExpandedNodeId("TargetId", browsePathTarget._targetId);
        encoder.encodeUInt32("RemainingPathIndex", browsePathTarget._remainingPathIndex);
    }

    public static BrowsePathTarget decode(UaDecoder decoder) {
        ExpandedNodeId _targetId = decoder.decodeExpandedNodeId("TargetId");
        UInteger _remainingPathIndex = decoder.decodeUInt32("RemainingPathIndex");
        return new BrowsePathTarget(_targetId, _remainingPathIndex);
    }

    static {
        DelegateRegistry.registerEncoder(BrowsePathTarget::encode, BrowsePathTarget.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(BrowsePathTarget::decode, BrowsePathTarget.class, BinaryEncodingId, XmlEncodingId);
    }
}

