/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;

@UaDataType(value="BrowsePathResult")
public class BrowsePathResult
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowsePathResult;
    public static final NodeId BinaryEncodingId = Identifiers.BrowsePathResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowsePathResult_Encoding_DefaultXml;
    protected final StatusCode _statusCode;
    protected final BrowsePathTarget[] _targets;

    public BrowsePathResult() {
        this._statusCode = null;
        this._targets = null;
    }

    public BrowsePathResult(StatusCode _statusCode, BrowsePathTarget[] _targets) {
        this._statusCode = _statusCode;
        this._targets = _targets;
    }

    public StatusCode getStatusCode() {
        return this._statusCode;
    }

    @Nullable
    public BrowsePathTarget[] getTargets() {
        return this._targets;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("StatusCode", (Object)this._statusCode).add("Targets", (Object)this._targets).toString();
    }

    public static void encode(BrowsePathResult browsePathResult, UaEncoder encoder) {
        encoder.encodeStatusCode("StatusCode", browsePathResult._statusCode);
        encoder.encodeArray("Targets", browsePathResult._targets, encoder::encodeSerializable);
    }

    public static BrowsePathResult decode(UaDecoder decoder) {
        StatusCode _statusCode = decoder.decodeStatusCode("StatusCode");
        BrowsePathTarget[] _targets = decoder.decodeArray("Targets", decoder::decodeSerializable, BrowsePathTarget.class);
        return new BrowsePathResult(_statusCode, _targets);
    }

    static {
        DelegateRegistry.registerEncoder(BrowsePathResult::encode, BrowsePathResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(BrowsePathResult::decode, BrowsePathResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

