/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;

@UaDataType(value="AttributeOperand")
public class AttributeOperand
extends FilterOperand {
    public static final NodeId TypeId = Identifiers.AttributeOperand;
    public static final NodeId BinaryEncodingId = Identifiers.AttributeOperand_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AttributeOperand_Encoding_DefaultXml;
    protected final NodeId _nodeId;
    protected final String _alias;
    protected final RelativePath _browsePath;
    protected final UInteger _attributeId;
    protected final String _indexRange;

    public AttributeOperand() {
        this._nodeId = null;
        this._alias = null;
        this._browsePath = null;
        this._attributeId = null;
        this._indexRange = null;
    }

    public AttributeOperand(NodeId _nodeId, String _alias, RelativePath _browsePath, UInteger _attributeId, String _indexRange) {
        this._nodeId = _nodeId;
        this._alias = _alias;
        this._browsePath = _browsePath;
        this._attributeId = _attributeId;
        this._indexRange = _indexRange;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public String getAlias() {
        return this._alias;
    }

    public RelativePath getBrowsePath() {
        return this._browsePath;
    }

    public UInteger getAttributeId() {
        return this._attributeId;
    }

    public String getIndexRange() {
        return this._indexRange;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this._nodeId).add("Alias", (Object)this._alias).add("BrowsePath", (Object)this._browsePath).add("AttributeId", (Object)this._attributeId).add("IndexRange", (Object)this._indexRange).toString();
    }

    public static void encode(AttributeOperand attributeOperand, UaEncoder encoder) {
        encoder.encodeNodeId("NodeId", attributeOperand._nodeId);
        encoder.encodeString("Alias", attributeOperand._alias);
        encoder.encodeSerializable("BrowsePath", attributeOperand._browsePath != null ? attributeOperand._browsePath : new RelativePath());
        encoder.encodeUInt32("AttributeId", attributeOperand._attributeId);
        encoder.encodeString("IndexRange", attributeOperand._indexRange);
    }

    public static AttributeOperand decode(UaDecoder decoder) {
        NodeId _nodeId = decoder.decodeNodeId("NodeId");
        String _alias = decoder.decodeString("Alias");
        RelativePath _browsePath = decoder.decodeSerializable("BrowsePath", RelativePath.class);
        UInteger _attributeId = decoder.decodeUInt32("AttributeId");
        String _indexRange = decoder.decodeString("IndexRange");
        return new AttributeOperand(_nodeId, _alias, _browsePath, _attributeId, _indexRange);
    }

    static {
        DelegateRegistry.registerEncoder(AttributeOperand::encode, AttributeOperand.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(AttributeOperand::decode, AttributeOperand.class, BinaryEncodingId, XmlEncodingId);
    }
}

