/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilterResult;

@UaDataType(value="AggregateFilterResult")
public class AggregateFilterResult
extends MonitoringFilterResult {
    public static final NodeId TypeId = Identifiers.AggregateFilterResult;
    public static final NodeId BinaryEncodingId = Identifiers.AggregateFilterResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AggregateFilterResult_Encoding_DefaultXml;
    protected final DateTime _revisedStartTime;
    protected final Double _revisedProcessingInterval;
    protected final AggregateConfiguration _revisedAggregateConfiguration;

    public AggregateFilterResult() {
        this._revisedStartTime = null;
        this._revisedProcessingInterval = null;
        this._revisedAggregateConfiguration = null;
    }

    public AggregateFilterResult(DateTime _revisedStartTime, Double _revisedProcessingInterval, AggregateConfiguration _revisedAggregateConfiguration) {
        this._revisedStartTime = _revisedStartTime;
        this._revisedProcessingInterval = _revisedProcessingInterval;
        this._revisedAggregateConfiguration = _revisedAggregateConfiguration;
    }

    public DateTime getRevisedStartTime() {
        return this._revisedStartTime;
    }

    public Double getRevisedProcessingInterval() {
        return this._revisedProcessingInterval;
    }

    public AggregateConfiguration getRevisedAggregateConfiguration() {
        return this._revisedAggregateConfiguration;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RevisedStartTime", (Object)this._revisedStartTime).add("RevisedProcessingInterval", (Object)this._revisedProcessingInterval).add("RevisedAggregateConfiguration", (Object)this._revisedAggregateConfiguration).toString();
    }

    public static void encode(AggregateFilterResult aggregateFilterResult, UaEncoder encoder) {
        encoder.encodeDateTime("RevisedStartTime", aggregateFilterResult._revisedStartTime);
        encoder.encodeDouble("RevisedProcessingInterval", aggregateFilterResult._revisedProcessingInterval);
        encoder.encodeSerializable("RevisedAggregateConfiguration", aggregateFilterResult._revisedAggregateConfiguration != null ? aggregateFilterResult._revisedAggregateConfiguration : new AggregateConfiguration());
    }

    public static AggregateFilterResult decode(UaDecoder decoder) {
        DateTime _revisedStartTime = decoder.decodeDateTime("RevisedStartTime");
        Double _revisedProcessingInterval = decoder.decodeDouble("RevisedProcessingInterval");
        AggregateConfiguration _revisedAggregateConfiguration = decoder.decodeSerializable("RevisedAggregateConfiguration", AggregateConfiguration.class);
        return new AggregateFilterResult(_revisedStartTime, _revisedProcessingInterval, _revisedAggregateConfiguration);
    }

    static {
        DelegateRegistry.registerEncoder(AggregateFilterResult::encode, AggregateFilterResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(AggregateFilterResult::decode, AggregateFilterResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

