/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

@UaDataType(value="AddReferencesItem")
public class AddReferencesItem
implements UaStructure {
    public static final NodeId TypeId = Identifiers.AddReferencesItem;
    public static final NodeId BinaryEncodingId = Identifiers.AddReferencesItem_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AddReferencesItem_Encoding_DefaultXml;
    protected final NodeId _sourceNodeId;
    protected final NodeId _referenceTypeId;
    protected final Boolean _isForward;
    protected final String _targetServerUri;
    protected final ExpandedNodeId _targetNodeId;
    protected final NodeClass _targetNodeClass;

    public AddReferencesItem() {
        this._sourceNodeId = null;
        this._referenceTypeId = null;
        this._isForward = null;
        this._targetServerUri = null;
        this._targetNodeId = null;
        this._targetNodeClass = null;
    }

    public AddReferencesItem(NodeId _sourceNodeId, NodeId _referenceTypeId, Boolean _isForward, String _targetServerUri, ExpandedNodeId _targetNodeId, NodeClass _targetNodeClass) {
        this._sourceNodeId = _sourceNodeId;
        this._referenceTypeId = _referenceTypeId;
        this._isForward = _isForward;
        this._targetServerUri = _targetServerUri;
        this._targetNodeId = _targetNodeId;
        this._targetNodeClass = _targetNodeClass;
    }

    public NodeId getSourceNodeId() {
        return this._sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this._referenceTypeId;
    }

    public Boolean getIsForward() {
        return this._isForward;
    }

    public String getTargetServerUri() {
        return this._targetServerUri;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this._targetNodeId;
    }

    public NodeClass getTargetNodeClass() {
        return this._targetNodeClass;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SourceNodeId", (Object)this._sourceNodeId).add("ReferenceTypeId", (Object)this._referenceTypeId).add("IsForward", (Object)this._isForward).add("TargetServerUri", (Object)this._targetServerUri).add("TargetNodeId", (Object)this._targetNodeId).add("TargetNodeClass", (Object)this._targetNodeClass).toString();
    }

    public static void encode(AddReferencesItem addReferencesItem, UaEncoder encoder) {
        encoder.encodeNodeId("SourceNodeId", addReferencesItem._sourceNodeId);
        encoder.encodeNodeId("ReferenceTypeId", addReferencesItem._referenceTypeId);
        encoder.encodeBoolean("IsForward", addReferencesItem._isForward);
        encoder.encodeString("TargetServerUri", addReferencesItem._targetServerUri);
        encoder.encodeExpandedNodeId("TargetNodeId", addReferencesItem._targetNodeId);
        encoder.encodeEnumeration("TargetNodeClass", addReferencesItem._targetNodeClass);
    }

    public static AddReferencesItem decode(UaDecoder decoder) {
        NodeId _sourceNodeId = decoder.decodeNodeId("SourceNodeId");
        NodeId _referenceTypeId = decoder.decodeNodeId("ReferenceTypeId");
        Boolean _isForward = decoder.decodeBoolean("IsForward");
        String _targetServerUri = decoder.decodeString("TargetServerUri");
        ExpandedNodeId _targetNodeId = decoder.decodeExpandedNodeId("TargetNodeId");
        NodeClass _targetNodeClass = decoder.decodeEnumeration("TargetNodeClass", NodeClass.class);
        return new AddReferencesItem(_sourceNodeId, _referenceTypeId, _isForward, _targetServerUri, _targetNodeId, _targetNodeClass);
    }

    static {
        DelegateRegistry.registerEncoder(AddReferencesItem::encode, AddReferencesItem.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(AddReferencesItem::decode, AddReferencesItem.class, BinaryEncodingId, XmlEncodingId);
    }
}

