/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum ServerState implements UaEnumeration
{
    Running(0),
    Failed(1),
    NoConfiguration(2),
    Suspended(3),
    Shutdown(4),
    Test(5),
    CommunicationFault(6),
    Unknown(7);

    private final int value;
    private static final ImmutableMap<Integer, ServerState> VALUES;

    private ServerState(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static ServerState from(Integer value) {
        if (value == null) {
            return null;
        }
        return (ServerState)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(ServerState serverState, UaEncoder encoder) {
        encoder.encodeInt32(null, serverState.getValue());
    }

    public static ServerState decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (ServerState)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ServerState e : ServerState.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(ServerState::encode, ServerState.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(ServerState::decode, ServerState.class, new NodeId[0]);
    }
}

