/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum OpenFileMode implements UaEnumeration
{
    Read(1),
    Write(2),
    EraseExisting(4),
    Append(8);

    private final int value;
    private static final ImmutableMap<Integer, OpenFileMode> VALUES;

    private OpenFileMode(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static OpenFileMode from(Integer value) {
        if (value == null) {
            return null;
        }
        return (OpenFileMode)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(OpenFileMode openFileMode, UaEncoder encoder) {
        encoder.encodeInt32(null, openFileMode.getValue());
    }

    public static OpenFileMode decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (OpenFileMode)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (OpenFileMode e : OpenFileMode.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(OpenFileMode::encode, OpenFileMode.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(OpenFileMode::decode, OpenFileMode.class, new NodeId[0]);
    }
}

