/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum ModelChangeStructureVerbMask implements UaEnumeration
{
    NodeAdded(1),
    NodeDeleted(2),
    ReferenceAdded(4),
    ReferenceDeleted(8),
    DataTypeChanged(16);

    private final int value;
    private static final ImmutableMap<Integer, ModelChangeStructureVerbMask> VALUES;

    private ModelChangeStructureVerbMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static ModelChangeStructureVerbMask from(Integer value) {
        if (value == null) {
            return null;
        }
        return (ModelChangeStructureVerbMask)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(ModelChangeStructureVerbMask modelChangeStructureVerbMask, UaEncoder encoder) {
        encoder.encodeInt32(null, modelChangeStructureVerbMask.getValue());
    }

    public static ModelChangeStructureVerbMask decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (ModelChangeStructureVerbMask)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModelChangeStructureVerbMask e : ModelChangeStructureVerbMask.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(ModelChangeStructureVerbMask::encode, ModelChangeStructureVerbMask.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(ModelChangeStructureVerbMask::decode, ModelChangeStructureVerbMask.class, new NodeId[0]);
    }
}

