/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum HistoryUpdateType implements UaEnumeration
{
    Insert(1),
    Replace(2),
    Update(3),
    Delete(4);

    private final int value;
    private static final ImmutableMap<Integer, HistoryUpdateType> VALUES;

    private HistoryUpdateType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static HistoryUpdateType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (HistoryUpdateType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(HistoryUpdateType historyUpdateType, UaEncoder encoder) {
        encoder.encodeInt32(null, historyUpdateType.getValue());
    }

    public static HistoryUpdateType decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (HistoryUpdateType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (HistoryUpdateType e : HistoryUpdateType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(HistoryUpdateType::encode, HistoryUpdateType.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(HistoryUpdateType::decode, HistoryUpdateType.class, new NodeId[0]);
    }
}

