/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum DeadbandType implements UaEnumeration
{
    None(0),
    Absolute(1),
    Percent(2);

    private final int value;
    private static final ImmutableMap<Integer, DeadbandType> VALUES;

    private DeadbandType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static DeadbandType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (DeadbandType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(DeadbandType deadbandType, UaEncoder encoder) {
        encoder.encodeInt32(null, deadbandType.getValue());
    }

    public static DeadbandType decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (DeadbandType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeadbandType e : DeadbandType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(DeadbandType::encode, DeadbandType.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(DeadbandType::decode, DeadbandType.class, new NodeId[0]);
    }
}

