/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum ComplianceLevel implements UaEnumeration
{
    Untested(0),
    Partial(1),
    SelfTested(2),
    Certified(3);

    private final int value;
    private static final ImmutableMap<Integer, ComplianceLevel> VALUES;

    private ComplianceLevel(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static ComplianceLevel from(Integer value) {
        if (value == null) {
            return null;
        }
        return (ComplianceLevel)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(ComplianceLevel complianceLevel, UaEncoder encoder) {
        encoder.encodeInt32(null, complianceLevel.getValue());
    }

    public static ComplianceLevel decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (ComplianceLevel)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ComplianceLevel e : ComplianceLevel.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(ComplianceLevel::encode, ComplianceLevel.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(ComplianceLevel::decode, ComplianceLevel.class, new NodeId[0]);
    }
}

