/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum BrowseDirection implements UaEnumeration
{
    Forward(0),
    Inverse(1),
    Both(2);

    private final int value;
    private static final ImmutableMap<Integer, BrowseDirection> VALUES;

    private BrowseDirection(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static BrowseDirection from(Integer value) {
        if (value == null) {
            return null;
        }
        return (BrowseDirection)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(BrowseDirection browseDirection, UaEncoder encoder) {
        encoder.encodeInt32(null, browseDirection.getValue());
    }

    public static BrowseDirection decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (BrowseDirection)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BrowseDirection e : BrowseDirection.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(BrowseDirection::encode, BrowseDirection.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(BrowseDirection::decode, BrowseDirection.class, new NodeId[0]);
    }
}

