/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public enum AxisScaleEnumeration implements UaEnumeration
{
    Linear(0),
    Log(1),
    Ln(2);

    private final int value;
    private static final ImmutableMap<Integer, AxisScaleEnumeration> VALUES;

    private AxisScaleEnumeration(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static AxisScaleEnumeration from(Integer value) {
        if (value == null) {
            return null;
        }
        return (AxisScaleEnumeration)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(AxisScaleEnumeration axisScaleEnumeration, UaEncoder encoder) {
        encoder.encodeInt32(null, axisScaleEnumeration.getValue());
    }

    public static AxisScaleEnumeration decode(UaDecoder decoder) {
        int value = decoder.decodeInt32(null);
        return (AxisScaleEnumeration)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AxisScaleEnumeration e : AxisScaleEnumeration.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
        DelegateRegistry.registerEncoder(AxisScaleEnumeration::encode, AxisScaleEnumeration.class, new NodeId[0]);
        DelegateRegistry.registerDecoder(AxisScaleEnumeration::decode, AxisScaleEnumeration.class, new NodeId[0]);
    }
}

