/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public final class NodeId {
    public static final NodeId NULL_NUMERIC = new NodeId(Unsigned.ushort(0), Unsigned.uint(0));
    public static final NodeId NULL_STRING = new NodeId(Unsigned.ushort(0), "");
    public static final NodeId NULL_GUID = new NodeId(Unsigned.ushort(0), new UUID(0L, 0L));
    public static final NodeId NULL_OPAQUE = new NodeId(Unsigned.ushort(0), ByteString.NULL_VALUE);
    public static final NodeId NULL_VALUE = NULL_NUMERIC;
    private final UShort namespaceIndex;
    private final Object identifier;
    private static final Pattern NS_INT = Pattern.compile("ns=(\\d*);i=(\\d*)");
    private static final Pattern NONE_INT = Pattern.compile("i=(\\d*)");
    private static final Pattern NS_STRING = Pattern.compile("ns=(\\d*);s=(.*)");
    private static final Pattern NONE_STRING = Pattern.compile("s=(.*)");
    private static final Pattern NS_GUID = Pattern.compile("ns=(\\d*);g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    private static final Pattern NONE_GUID = Pattern.compile("g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    private static final Pattern NS_OPAQUE = Pattern.compile("ns=(\\d*);b=([0-9a-zA-Z+/=]*)");
    private static final Pattern NONE_OPAQUE = Pattern.compile("b=([0-9a-zA-Z+/=]*)");

    public NodeId(int namespaceIndex, int identifier) {
        this(Unsigned.ushort(namespaceIndex), Unsigned.uint(identifier));
    }

    public NodeId(int namespaceIndex, UInteger identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, String identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, UUID identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, ByteString identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(UShort namespaceIndex, UInteger identifier) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        Preconditions.checkNotNull((Object)identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, int identifier) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        this.namespaceIndex = namespaceIndex;
        this.identifier = Unsigned.uint(identifier);
    }

    public NodeId(UShort namespaceIndex, String identifier) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        if (identifier == null) {
            identifier = "";
        }
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, UUID identifier) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        Preconditions.checkNotNull((Object)identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, ByteString identifier) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        Preconditions.checkNotNull((Object)identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public IdType getType() {
        if (this.identifier instanceof UInteger) {
            return IdType.Numeric;
        }
        if (this.identifier instanceof String) {
            return IdType.String;
        }
        if (this.identifier instanceof UUID) {
            return IdType.Guid;
        }
        return IdType.Opaque;
    }

    public ExpandedNodeId expanded() {
        return new ExpandedNodeId(this);
    }

    public boolean isNull() {
        return this.namespaceIndex.intValue() == 0 && (NULL_NUMERIC.equals(this) || NULL_STRING.equals(this) || NULL_GUID.equals(this) || NULL_OPAQUE.equals(this));
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return this.identifier.equals(nodeId.identifier) && this.namespaceIndex.equals(nodeId.namespaceIndex);
    }

    public int hashCode() {
        int result = this.namespaceIndex.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ns", (Object)this.namespaceIndex).add("id", this.identifier).toString();
    }

    public String toParseableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ns=").append(this.namespaceIndex).append(";");
        switch (this.getType()) {
            case Numeric: {
                sb.append("i=").append(this.identifier);
                break;
            }
            case String: {
                sb.append("s=").append(this.identifier);
                break;
            }
            case Guid: {
                sb.append("g=").append(this.identifier);
                break;
            }
            case Opaque: {
                ByteString bs = (ByteString)this.identifier;
                if (bs.isNull()) {
                    sb.append("b=");
                    break;
                }
                sb.append("b=").append(DatatypeConverter.printBase64Binary((byte[])bs.bytes()));
                break;
            }
            default: {
                throw new IllegalStateException("unknown IdType: " + this.getType());
            }
        }
        return sb.toString();
    }

    public static NodeId parse(@Nonnull String s) {
        if (s.startsWith("ns=")) {
            Matcher m = NS_INT.matcher(s);
            if (m.matches()) {
                Integer nsi = Integer.valueOf(m.group(1));
                Integer obj = Integer.valueOf(m.group(2));
                return new NodeId(Unsigned.ushort(nsi), Unsigned.uint(obj));
            }
            m = NS_STRING.matcher(s);
            if (m.matches()) {
                Integer nsi = Integer.valueOf(m.group(1));
                String obj = m.group(2);
                return new NodeId(Unsigned.ushort(nsi), obj);
            }
            m = NS_GUID.matcher(s);
            if (m.matches()) {
                Integer nsi = Integer.valueOf(m.group(1));
                UUID obj = UUID.fromString(m.group(2));
                return new NodeId(Unsigned.ushort(nsi), obj);
            }
            m = NS_OPAQUE.matcher(s);
            if (m.matches()) {
                Integer nsi = Integer.valueOf(m.group(1));
                byte[] obj = DatatypeConverter.parseBase64Binary((String)m.group(2));
                return new NodeId(Unsigned.ushort(nsi), ByteString.of(obj));
            }
        } else {
            Matcher m = NONE_STRING.matcher(s);
            if (m.matches()) {
                String obj = m.group(1);
                return new NodeId(Unsigned.ushort(0), obj);
            }
            m = NONE_INT.matcher(s);
            if (m.matches()) {
                Integer obj = Integer.valueOf(m.group(1));
                return new NodeId(Unsigned.ushort(0), Unsigned.uint(obj));
            }
            m = NONE_GUID.matcher(s);
            if (m.matches()) {
                UUID obj = UUID.fromString(m.group(1));
                return new NodeId(Unsigned.ushort(0), obj);
            }
            m = NONE_OPAQUE.matcher(s);
            if (m.matches()) {
                byte[] obj = DatatypeConverter.parseBase64Binary((String)m.group(1));
                return new NodeId(Unsigned.ushort(0), ByteString.of(obj));
            }
        }
        throw new UaRuntimeException(0x80330000L);
    }

    public static Optional<NodeId> parseSafe(String s) {
        try {
            return Optional.of(NodeId.parse(s));
        }
        catch (UaRuntimeException e) {
            return Optional.empty();
        }
    }
}

