/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;

public final class ExtensionObject {
    private volatile Object decoded;
    private final BodyType bodyType;
    private final Object encoded;
    private final NodeId encodingTypeId;

    public ExtensionObject(ByteString encoded, NodeId encodingTypeId) {
        this.encoded = encoded;
        this.encodingTypeId = encodingTypeId;
        this.bodyType = BodyType.ByteString;
    }

    public ExtensionObject(XmlElement encoded, NodeId encodingTypeId) {
        this.encoded = encoded;
        this.encodingTypeId = encodingTypeId;
        this.bodyType = BodyType.XmlElement;
    }

    public Object getEncoded() {
        return this.encoded;
    }

    public NodeId getEncodingTypeId() {
        return this.encodingTypeId;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public <T> T decode() throws UaSerializationException {
        return this.decode(DataTypeEncoding.OPC_UA);
    }

    public <T> T decode(DataTypeEncoding context) throws UaSerializationException {
        if (this.decoded != null) {
            return (T)this.decoded;
        }
        switch (this.bodyType) {
            case ByteString: {
                ByteString bs = (ByteString)this.encoded;
                if (bs == null || bs.isNull()) {
                    return null;
                }
                this.decoded = context.decodeFromByteString((ByteString)this.encoded, this.encodingTypeId);
                return (T)this.decoded;
            }
            case XmlElement: {
                XmlElement e = (XmlElement)this.encoded;
                if (e == null || e.isNull()) {
                    return null;
                }
                this.decoded = context.decodeFromXmlElement((XmlElement)this.encoded, this.encodingTypeId);
                return (T)this.decoded;
            }
        }
        throw new IllegalStateException("unknown body type: " + (Object)((Object)this.bodyType));
    }

    public static ExtensionObject encode(UaStructure structure) throws UaSerializationException {
        return ExtensionObject.encodeAsByteString(structure, structure.getBinaryEncodingId());
    }

    public static ExtensionObject encodeAsByteString(Object object, NodeId encodingTypeId) throws UaSerializationException {
        return ExtensionObject.encodeAsByteString(object, encodingTypeId, DataTypeEncoding.OPC_UA);
    }

    public static ExtensionObject encodeAsByteString(Object object, NodeId encodingTypeId, DataTypeEncoding context) throws UaSerializationException {
        ByteString encoded = context.encodeToByteString(object, encodingTypeId);
        return new ExtensionObject(encoded, encodingTypeId);
    }

    public static ExtensionObject encodeAsXmlElement(Object object, NodeId encodingTypeId) throws UaSerializationException {
        return ExtensionObject.encodeAsXmlElement(object, encodingTypeId, DataTypeEncoding.OPC_UA);
    }

    public static ExtensionObject encodeAsXmlElement(Object object, NodeId encodingTypeId, DataTypeEncoding context) throws UaSerializationException {
        XmlElement encoded = context.encodeToXmlElement(object, encodingTypeId);
        return new ExtensionObject(encoded, encodingTypeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return Objects.equal((Object)this.encoded, (Object)that.encoded) && Objects.equal((Object)this.encodingTypeId, (Object)that.encodingTypeId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.encoded, this.encodingTypeId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("encoded", this.encoded).add("encodingTypeId", (Object)this.encodingTypeId).toString();
    }

    public static enum BodyType {
        ByteString,
        XmlElement;

    }
}

