/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public final class DiagnosticInfo {
    public static final DiagnosticInfo NULL_VALUE = new DiagnosticInfo(-1, -1, -1, -1, null, null, null);
    private final int namespaceUri;
    private final int symbolicId;
    private final int locale;
    private final int localizedText;
    private final String additionalInfo;
    private final StatusCode innerStatusCode;
    private final DiagnosticInfo innerDiagnosticInfo;

    public DiagnosticInfo(int namespaceUri, int symbolicId, int locale, int localizedText, String additionalInfo, StatusCode innerStatusCode, DiagnosticInfo innerDiagnosticInfo) {
        this.namespaceUri = namespaceUri;
        this.symbolicId = symbolicId;
        this.locale = locale;
        this.localizedText = localizedText;
        this.additionalInfo = additionalInfo;
        this.innerStatusCode = innerStatusCode;
        this.innerDiagnosticInfo = innerDiagnosticInfo;
    }

    public int getNamespaceUri() {
        return this.namespaceUri;
    }

    public int getSymbolicId() {
        return this.symbolicId;
    }

    public int getLocale() {
        return this.locale;
    }

    public int getLocalizedText() {
        return this.localizedText;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public StatusCode getInnerStatusCode() {
        return this.innerStatusCode;
    }

    public DiagnosticInfo getInnerDiagnosticInfo() {
        return this.innerDiagnosticInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticInfo that = (DiagnosticInfo)o;
        return Objects.equals(this.symbolicId, that.symbolicId) && Objects.equals(this.namespaceUri, that.namespaceUri) && Objects.equals(this.localizedText, that.localizedText) && Objects.equals(this.locale, that.locale) && Objects.equals(this.additionalInfo, that.additionalInfo) && Objects.equals(this.innerStatusCode, that.innerStatusCode) && Objects.equals(this.innerDiagnosticInfo, that.innerDiagnosticInfo);
    }

    public int hashCode() {
        int result = this.namespaceUri;
        result = 31 * result + this.symbolicId;
        result = 31 * result + this.locale;
        result = 31 * result + this.localizedText;
        result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
        result = 31 * result + (this.innerStatusCode != null ? this.innerStatusCode.hashCode() : 0);
        result = 31 * result + (this.innerDiagnosticInfo != null ? this.innerDiagnosticInfo.hashCode() : 0);
        return result;
    }
}

