/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.binary;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.EncoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
implements UaEncoder {
    private static final DelegateRegistry.Instance DELEGATE_REGISTRY = DelegateRegistry.getInstance();
    private volatile ByteBuf buffer;
    private final int maxArrayLength;
    private final int maxStringLength;

    public BinaryEncoder() {
        this(65536, 65536);
    }

    public BinaryEncoder(int maxArrayLength, int maxStringLength) {
        this.maxArrayLength = maxArrayLength;
        this.maxStringLength = maxStringLength;
    }

    public BinaryEncoder setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public void encodeBoolean(String field, Boolean value) {
        if (value == null) {
            this.buffer.writeBoolean(false);
        } else {
            this.buffer.writeBoolean(value.booleanValue());
        }
    }

    @Override
    public void encodeSByte(String field, Byte value) {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte((int)value.byteValue());
        }
    }

    @Override
    public void encodeInt16(String field, Short value) {
        if (value == null) {
            this.buffer.writeShort(0);
        } else {
            this.buffer.writeShort((int)value.shortValue());
        }
    }

    @Override
    public void encodeInt32(String field, Integer value) {
        if (value == null) {
            this.buffer.writeInt(0);
        } else {
            this.buffer.writeInt(value.intValue());
        }
    }

    @Override
    public void encodeInt64(String field, Long value) {
        if (value == null) {
            this.buffer.writeLong(0L);
        } else {
            this.buffer.writeLong(value.longValue());
        }
    }

    @Override
    public void encodeByte(String field, UByte value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(value.intValue());
        }
    }

    @Override
    public void encodeUInt16(String field, UShort value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeShort(0);
        } else {
            this.buffer.writeShort(value.intValue());
        }
    }

    @Override
    public void encodeUInt32(String field, UInteger value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeInt(0);
        } else {
            this.buffer.writeInt(value.intValue());
        }
    }

    @Override
    public void encodeUInt64(String field, ULong value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeLong(0L);
        } else {
            this.buffer.writeLong(value.longValue());
        }
    }

    @Override
    public void encodeFloat(String field, Float value) {
        if (value == null) {
            this.buffer.writeFloat(0.0f);
        } else {
            this.buffer.writeFloat(value.floatValue());
        }
    }

    @Override
    public void encodeDouble(String field, Double value) {
        if (value == null) {
            this.buffer.writeDouble(0.0);
        } else {
            this.buffer.writeDouble(value.doubleValue());
        }
    }

    @Override
    public void encodeString(String field, String value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeInt(-1);
        } else {
            if (value.length() > this.maxStringLength) {
                throw new UaSerializationException(0x80080000L, "max string length exceeded");
            }
            try {
                int lengthIndex = this.buffer.writerIndex();
                this.buffer.writeInt(0x42424242);
                int indexBefore = this.buffer.writerIndex();
                this.buffer.writeBytes(value.getBytes("UTF-8"));
                int indexAfter = this.buffer.writerIndex();
                int bytesWritten = indexAfter - indexBefore;
                this.buffer.writerIndex(lengthIndex);
                this.buffer.writeInt(bytesWritten);
                this.buffer.writerIndex(indexAfter);
            }
            catch (UnsupportedEncodingException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeDateTime(String field, DateTime value) {
        if (value == null) {
            this.buffer.writeLong(0L);
        } else {
            this.buffer.writeLong(value.getUtcTime());
        }
    }

    @Override
    public void encodeGuid(String field, UUID value) {
        if (value == null) {
            this.buffer.writeZero(16);
        } else {
            long msb = value.getMostSignificantBits();
            long lsb = value.getLeastSignificantBits();
            this.buffer.writeInt((int)(msb >>> 32));
            this.buffer.writeShort((int)(msb >>> 16) & 0xFFFF);
            this.buffer.writeShort((int)msb & 0xFFFF);
            this.buffer.order(ByteOrder.BIG_ENDIAN).writeLong(lsb);
        }
    }

    @Override
    public void encodeByteString(String field, ByteString value) {
        if (value == null || value.isNull()) {
            this.buffer.writeInt(-1);
        } else {
            byte[] bytes = value.bytes();
            assert (bytes != null);
            this.buffer.writeInt(bytes.length);
            this.buffer.writeBytes(bytes);
        }
    }

    @Override
    public void encodeXmlElement(String field, XmlElement value) throws UaSerializationException {
        if (value == null || value.isNull()) {
            this.buffer.writeInt(-1);
        } else {
            try {
                this.encodeByteString(null, new ByteString(value.getFragment().getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new UaSerializationException(0x80070000L, (Throwable)e);
            }
        }
    }

    @Override
    public void encodeNodeId(String field, NodeId value) throws UaSerializationException {
        if (value == null) {
            value = NodeId.NULL_VALUE;
        }
        int namespaceIndex = value.getNamespaceIndex().intValue();
        if (value.getType() == IdType.Numeric) {
            UInteger identifier = (UInteger)value.getIdentifier();
            long idv = identifier.longValue();
            if (namespaceIndex == 0 && idv >= 0L && idv <= 255L) {
                this.buffer.writeByte(0);
                this.buffer.writeByte((int)idv);
            } else if (namespaceIndex >= 0 && namespaceIndex <= 255 && idv <= 65535L) {
                this.buffer.writeByte(1);
                this.buffer.writeByte(namespaceIndex);
                this.buffer.writeShort((int)idv);
            } else {
                this.buffer.writeByte(2);
                this.buffer.writeShort(namespaceIndex);
                this.buffer.writeInt((int)idv);
            }
        } else if (value.getType() == IdType.String) {
            String identifier = (String)value.getIdentifier();
            this.buffer.writeByte(3);
            this.buffer.writeShort(namespaceIndex);
            this.encodeString(null, identifier);
        } else if (value.getType() == IdType.Guid) {
            UUID identifier = (UUID)value.getIdentifier();
            this.buffer.writeByte(4);
            this.buffer.writeShort(namespaceIndex);
            this.encodeGuid(null, identifier);
        } else if (value.getType() == IdType.Opaque) {
            ByteString identifier = (ByteString)value.getIdentifier();
            this.buffer.writeByte(5);
            this.buffer.writeShort(namespaceIndex);
            this.encodeByteString(null, identifier);
        } else {
            throw new UaSerializationException(0x80060000L, "invalid identifier: " + value.getIdentifier());
        }
    }

    @Override
    public void encodeExpandedNodeId(String field, ExpandedNodeId value) throws UaSerializationException {
        if (value == null) {
            value = ExpandedNodeId.NULL_VALUE;
        }
        int flags = 0;
        String namespaceUri = value.getNamespaceUri();
        long serverIndex = value.getServerIndex();
        if (namespaceUri != null && namespaceUri.length() > 0) {
            flags |= 0x80;
        }
        if (serverIndex > 0L) {
            flags |= 0x40;
        }
        int namespaceIndex = value.getNamespaceIndex().intValue();
        if (value.getType() == IdType.Numeric) {
            UInteger identifier = (UInteger)value.getIdentifier();
            long idv = identifier.longValue();
            if (namespaceIndex == 0 && idv >= 0L && idv <= 255L) {
                this.buffer.writeByte(flags);
                this.buffer.writeByte((int)idv);
            } else if (namespaceIndex >= 0 && namespaceIndex <= 255 && idv <= 65535L) {
                this.buffer.writeByte(1 | flags);
                this.buffer.writeByte(namespaceIndex);
                this.buffer.writeShort((int)idv);
            } else {
                this.buffer.writeByte(2 | flags);
                this.buffer.writeShort(namespaceIndex);
                this.buffer.writeInt((int)idv);
            }
        } else if (value.getType() == IdType.String) {
            String identifier = (String)value.getIdentifier();
            this.buffer.writeByte(3 | flags);
            this.buffer.writeShort(namespaceIndex);
            this.encodeString(null, identifier);
        } else if (value.getType() == IdType.Guid) {
            UUID identifier = (UUID)value.getIdentifier();
            this.buffer.writeByte(4 | flags);
            this.buffer.writeShort(namespaceIndex);
            this.encodeGuid(null, identifier);
        } else if (value.getType() == IdType.Opaque) {
            ByteString identifier = (ByteString)value.getIdentifier();
            this.buffer.writeByte(5 | flags);
            this.buffer.writeShort(namespaceIndex);
            this.encodeByteString(null, identifier);
        } else {
            throw new UaSerializationException(0x80060000L, "invalid identifier: " + value.getIdentifier());
        }
        if (namespaceUri != null && namespaceUri.length() > 0) {
            this.encodeString(null, namespaceUri);
        }
        if (serverIndex > 0L) {
            this.encodeUInt32(null, Unsigned.uint(serverIndex));
        }
    }

    @Override
    public void encodeStatusCode(String field, StatusCode value) {
        if (value == null) {
            this.buffer.writeInt(0);
        } else {
            this.encodeUInt32(null, Unsigned.uint(value.getValue()));
        }
    }

    @Override
    public void encodeQualifiedName(String field, QualifiedName value) throws UaSerializationException {
        if (value == null) {
            value = QualifiedName.NULL_VALUE;
        }
        this.encodeUInt16(null, value.getNamespaceIndex());
        this.encodeString(null, value.getName());
    }

    @Override
    public void encodeLocalizedText(String field, LocalizedText value) throws UaSerializationException {
        if (value == null) {
            value = LocalizedText.NULL_VALUE;
        }
        String locale = value.getLocale();
        String text = value.getText();
        int mask = 3;
        if (locale == null || locale.isEmpty()) {
            mask ^= 1;
        }
        if (text == null || text.isEmpty()) {
            mask ^= 2;
        }
        this.buffer.writeByte(mask);
        if (locale != null && !locale.isEmpty()) {
            this.encodeString(null, locale);
        }
        if (text != null && !text.isEmpty()) {
            this.encodeString(null, text);
        }
    }

    @Override
    public void encodeExtensionObject(String field, ExtensionObject value) throws UaSerializationException {
        if (value == null || value.getEncoded() == null) {
            this.encodeNodeId(null, NodeId.NULL_VALUE);
            this.buffer.writeByte(0);
        } else {
            Object object = value.getEncoded();
            switch (value.getBodyType()) {
                case ByteString: {
                    ByteString byteString = (ByteString)object;
                    this.encodeNodeId(null, value.getEncodingTypeId());
                    this.buffer.writeByte(1);
                    this.encodeByteString(null, byteString);
                    break;
                }
                case XmlElement: {
                    XmlElement xmlElement = (XmlElement)object;
                    this.encodeNodeId(null, value.getEncodingTypeId());
                    this.buffer.writeByte(2);
                    this.encodeXmlElement(null, xmlElement);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown body type: " + (Object)((Object)value.getBodyType()));
                }
            }
        }
    }

    @Override
    public void encodeDataValue(String field, DataValue value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            int mask = 0;
            if (value.getValue() != null && value.getValue().isNotNull()) {
                mask |= 1;
            }
            if (!StatusCode.GOOD.equals(value.getStatusCode())) {
                mask |= 2;
            }
            if (!DateTime.MIN_VALUE.equals(value.getSourceTime())) {
                mask |= 4;
            }
            if (!DateTime.MIN_VALUE.equals(value.getServerTime())) {
                mask |= 8;
            }
            this.buffer.writeByte(mask);
            if ((mask & 1) == 1) {
                this.encodeVariant(null, value.getValue());
            }
            if ((mask & 2) == 2) {
                this.encodeStatusCode(null, value.getStatusCode());
            }
            if ((mask & 4) == 4) {
                this.encodeDateTime(null, value.getSourceTime());
            }
            if ((mask & 8) == 8) {
                this.encodeDateTime(null, value.getServerTime());
            }
        }
    }

    @Override
    public void encodeVariant(String field, Variant variant) throws UaSerializationException {
        Object value = variant.getValue();
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            boolean structure = false;
            boolean enumeration = false;
            Class<Object> valueClass = this.getClass(value);
            if (UaStructure.class.isAssignableFrom(valueClass)) {
                valueClass = ExtensionObject.class;
                structure = true;
            } else if (UaEnumeration.class.isAssignableFrom(valueClass)) {
                valueClass = Integer.class;
                enumeration = true;
            }
            int typeId = TypeUtil.getBuiltinTypeId(valueClass);
            if (typeId == -1) {
                LoggerFactory.getLogger(this.getClass()).warn("Not a built-in type: {}", valueClass);
            }
            if (value.getClass().isArray()) {
                int[] dimensions = ArrayUtil.getDimensions(value);
                if (dimensions.length == 1) {
                    this.buffer.writeByte(typeId | 0x80);
                    int length = Array.getLength(value);
                    this.buffer.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        Object o = Array.get(value, i);
                        this.encodeValue(o, typeId, structure, enumeration);
                    }
                } else {
                    this.buffer.writeByte(typeId | 0xC0);
                    Object flattened = ArrayUtil.flatten(value);
                    int length = Array.getLength(flattened);
                    this.buffer.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        Object o = Array.get(flattened, i);
                        this.encodeValue(o, typeId, structure, enumeration);
                    }
                    this.encodeInt32(null, dimensions.length);
                    for (int dimension : dimensions) {
                        this.encodeInt32(null, dimension);
                    }
                }
            } else {
                this.buffer.writeByte(typeId);
                this.encodeValue(value, typeId, structure, enumeration);
            }
        }
    }

    private void encodeValue(Object value, int typeId, boolean structure, boolean enumeration) {
        if (structure) {
            ExtensionObject extensionObject = ExtensionObject.encode((UaStructure)value);
            this.encodeBuiltinType(typeId, extensionObject);
        } else if (enumeration) {
            this.encodeBuiltinType(typeId, ((UaEnumeration)value).getValue());
        } else {
            this.encodeBuiltinType(typeId, value);
        }
    }

    private Class<?> getClass(@Nonnull Object o) {
        if (o.getClass().isArray()) {
            return ArrayUtil.getType(o);
        }
        return o.getClass();
    }

    @Override
    public void encodeDiagnosticInfo(String field, DiagnosticInfo value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            int mask = 127;
            if (value.getSymbolicId() == -1) {
                mask ^= 1;
            }
            if (value.getNamespaceUri() == -1) {
                mask ^= 2;
            }
            if (value.getLocalizedText() == -1) {
                mask ^= 4;
            }
            if (value.getLocale() == -1) {
                mask ^= 8;
            }
            if (value.getAdditionalInfo() == null || value.getAdditionalInfo().isEmpty()) {
                mask ^= 0x10;
            }
            if (value.getInnerStatusCode() == null) {
                mask ^= 0x20;
            }
            if (value.getInnerDiagnosticInfo() == null) {
                mask ^= 0x40;
            }
            this.buffer.writeByte(mask);
            if ((mask & 1) == 1) {
                this.encodeInt32(null, value.getSymbolicId());
            }
            if ((mask & 2) == 2) {
                this.encodeInt32(null, value.getNamespaceUri());
            }
            if ((mask & 4) == 4) {
                this.encodeInt32(null, value.getLocalizedText());
            }
            if ((mask & 8) == 8) {
                this.encodeInt32(null, value.getLocale());
            }
            if ((mask & 0x10) == 16) {
                this.encodeString(null, value.getAdditionalInfo());
            }
            if ((mask & 0x20) == 32) {
                this.encodeStatusCode(null, value.getInnerStatusCode());
            }
            if ((mask & 0x40) == 64) {
                this.encodeDiagnosticInfo(null, value.getInnerDiagnosticInfo());
            }
        }
    }

    @Override
    public <T extends UaStructure> void encodeMessage(String field, T message) throws UaSerializationException {
        EncoderDelegate<T> delegate = DELEGATE_REGISTRY.getEncoder(message.getBinaryEncodingId());
        this.encodeNodeId(null, message.getBinaryEncodingId());
        delegate.encode(message, this);
    }

    @Override
    public <T extends UaEnumeration> void encodeEnumeration(String field, T value) throws UaSerializationException {
        if (value == null) {
            this.encodeInt32(null, -1);
        } else {
            EncoderDelegate<T> delegate = DELEGATE_REGISTRY.getEncoder(value);
            delegate.encode(value, this);
        }
    }

    @Override
    public <T extends UaSerializable> void encodeSerializable(String field, T value) throws UaSerializationException {
        EncoderDelegate<T> delegate = DELEGATE_REGISTRY.getEncoder(value);
        delegate.encode(value, this);
    }

    @Override
    public <T> void encodeArray(String field, T[] values, BiConsumer<String, T> consumer) throws UaSerializationException {
        if (values == null) {
            this.buffer.writeInt(-1);
        } else {
            if (values.length > this.maxArrayLength) {
                throw new UaSerializationException(0x80080000L, "max array length exceeded");
            }
            this.encodeInt32(null, values.length);
            for (T t : values) {
                consumer.accept(null, t);
            }
        }
    }

    private void encodeBuiltinType(int typeId, Object value) throws UaSerializationException {
        switch (typeId) {
            case 1: {
                this.encodeBoolean(null, (Boolean)value);
                break;
            }
            case 2: {
                this.encodeSByte(null, (Byte)value);
                break;
            }
            case 3: {
                this.encodeByte(null, (UByte)value);
                break;
            }
            case 4: {
                this.encodeInt16(null, (Short)value);
                break;
            }
            case 5: {
                this.encodeUInt16(null, (UShort)value);
                break;
            }
            case 6: {
                this.encodeInt32(null, (Integer)value);
                break;
            }
            case 7: {
                this.encodeUInt32(null, (UInteger)value);
                break;
            }
            case 8: {
                this.encodeInt64(null, (Long)value);
                break;
            }
            case 9: {
                this.encodeUInt64(null, (ULong)value);
                break;
            }
            case 10: {
                this.encodeFloat(null, (Float)value);
                break;
            }
            case 11: {
                this.encodeDouble(null, (Double)value);
                break;
            }
            case 12: {
                this.encodeString(null, (String)value);
                break;
            }
            case 13: {
                this.encodeDateTime(null, (DateTime)value);
                break;
            }
            case 14: {
                this.encodeGuid(null, (UUID)value);
                break;
            }
            case 15: {
                this.encodeByteString(null, (ByteString)value);
                break;
            }
            case 16: {
                this.encodeXmlElement(null, (XmlElement)value);
                break;
            }
            case 17: {
                this.encodeNodeId(null, (NodeId)value);
                break;
            }
            case 18: {
                this.encodeExpandedNodeId(null, (ExpandedNodeId)value);
                break;
            }
            case 19: {
                this.encodeStatusCode(null, (StatusCode)value);
                break;
            }
            case 20: {
                this.encodeQualifiedName(null, (QualifiedName)value);
                break;
            }
            case 21: {
                this.encodeLocalizedText(null, (LocalizedText)value);
                break;
            }
            case 22: {
                this.encodeExtensionObject(null, (ExtensionObject)value);
                break;
            }
            case 23: {
                this.encodeDataValue(null, (DataValue)value);
                break;
            }
            case 24: {
                this.encodeVariant(null, (Variant)value);
                break;
            }
            case 25: {
                this.encodeDiagnosticInfo(null, (DiagnosticInfo)value);
                break;
            }
            default: {
                throw new UaSerializationException(0x80070000L, "unknown builtin type: " + typeId);
            }
        }
    }
}

