/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.binary;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DecoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;

public class BinaryDecoder
implements UaDecoder {
    private static final DelegateRegistry.Instance DELEGATE_REGISTRY = DelegateRegistry.getInstance();
    private volatile ByteBuf buffer;
    private final int maxArrayLength;
    private final int maxStringLength;

    public BinaryDecoder() {
        this(65536, 65536);
    }

    public BinaryDecoder(int maxArrayLength, int maxStringLength) {
        this.maxArrayLength = maxArrayLength;
        this.maxStringLength = maxStringLength;
    }

    public BinaryDecoder setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public Boolean decodeBoolean(String field) {
        return this.buffer.readBoolean();
    }

    @Override
    public Byte decodeSByte(String field) {
        return this.buffer.readByte();
    }

    @Override
    public Short decodeInt16(String field) {
        return this.buffer.readShort();
    }

    @Override
    public Integer decodeInt32(String field) {
        return this.buffer.readInt();
    }

    @Override
    public Long decodeInt64(String field) {
        return this.buffer.readLong();
    }

    @Override
    public UByte decodeByte(String field) {
        return Unsigned.ubyte(this.buffer.readUnsignedByte());
    }

    @Override
    public UShort decodeUInt16(String field) {
        return Unsigned.ushort(this.buffer.readUnsignedShort());
    }

    @Override
    public UInteger decodeUInt32(String field) {
        return Unsigned.uint(this.buffer.readUnsignedInt());
    }

    @Override
    public ULong decodeUInt64(String field) {
        return Unsigned.ulong(this.buffer.readLong());
    }

    @Override
    public Float decodeFloat(String field) {
        return Float.valueOf(this.buffer.readFloat());
    }

    @Override
    public Double decodeDouble(String field) {
        return this.buffer.readDouble();
    }

    @Override
    public String decodeString(String field) throws UaSerializationException {
        int length = this.decodeInt32(null);
        if (length == -1) {
            return null;
        }
        if (length > this.maxStringLength) {
            throw new UaSerializationException(0x80080000L, String.format("max string length exceeded (length=%s, max=%s)", length, this.maxStringLength));
        }
        String s = this.buffer.toString(this.buffer.readerIndex(), length, Charset.forName("UTF-8"));
        this.buffer.skipBytes(length);
        return s;
    }

    @Override
    public DateTime decodeDateTime(String field) {
        return new DateTime(this.buffer.readLong());
    }

    @Override
    public UUID decodeGuid(String field) {
        long part1 = this.buffer.readUnsignedInt();
        long part2 = this.buffer.readUnsignedShort();
        long part3 = this.buffer.readUnsignedShort();
        long part4 = this.buffer.order(ByteOrder.BIG_ENDIAN).readLong();
        long msb = part1 << 32 | part2 << 16 | part3;
        return new UUID(msb, part4);
    }

    @Override
    public ByteString decodeByteString(String field) {
        int length = this.decodeInt32(null);
        if (length == -1) {
            return ByteString.NULL_VALUE;
        }
        byte[] bs = new byte[length];
        this.buffer.readBytes(bs);
        return new ByteString(bs);
    }

    @Override
    public XmlElement decodeXmlElement(String field) throws UaSerializationException {
        ByteString byteString = this.decodeByteString(null);
        byte[] bs = byteString.bytes();
        if (bs == null) {
            return new XmlElement(null);
        }
        try {
            String fragment = new String(bs, "UTF-8");
            return new XmlElement(fragment);
        }
        catch (UnsupportedEncodingException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    @Override
    public NodeId decodeNodeId(String field) throws UaSerializationException {
        int format = this.buffer.readByte() & 0xF;
        if (format == 0) {
            return new NodeId(Unsigned.ushort(0), Unsigned.uint(this.buffer.readUnsignedByte()));
        }
        if (format == 1) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedByte()), Unsigned.uint(this.buffer.readUnsignedShort()));
        }
        if (format == 2) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedShort()), Unsigned.uint(this.buffer.readUnsignedInt()));
        }
        if (format == 3) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedShort()), this.decodeString(null));
        }
        if (format == 4) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedShort()), this.decodeGuid(null));
        }
        if (format == 5) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedShort()), this.decodeByteString(null));
        }
        throw new UaSerializationException(0x80070000L, "invalid NodeId format: " + format);
    }

    @Override
    public ExpandedNodeId decodeExpandedNodeId(String field) throws UaSerializationException {
        byte flags = this.buffer.getByte(this.buffer.readerIndex());
        NodeId nodeId = this.decodeNodeId(null);
        String namespaceUri = null;
        long serverIndex = 0L;
        if ((flags & 0x80) == 128) {
            namespaceUri = this.decodeString(null);
        }
        if ((flags & 0x40) == 64) {
            serverIndex = this.decodeUInt32(null).longValue();
        }
        return new ExpandedNodeId(nodeId, namespaceUri, serverIndex);
    }

    @Override
    public StatusCode decodeStatusCode(String field) {
        return new StatusCode(this.decodeUInt32(null));
    }

    @Override
    public QualifiedName decodeQualifiedName(String field) throws UaSerializationException {
        int namespaceIndex = this.decodeUInt16(null).intValue();
        String name = this.decodeString(null);
        return new QualifiedName(Unsigned.ushort(namespaceIndex), name);
    }

    @Override
    public LocalizedText decodeLocalizedText(String field) throws UaSerializationException {
        byte mask = this.buffer.readByte();
        String locale = null;
        String text = null;
        if ((mask & 1) == 1) {
            locale = this.decodeString(null);
        }
        if ((mask & 2) == 2) {
            text = this.decodeString(null);
        }
        return new LocalizedText(locale, text);
    }

    @Override
    public ExtensionObject decodeExtensionObject(String field) throws UaSerializationException {
        NodeId encodingTypeId = this.decodeNodeId(null);
        byte encoding = this.buffer.readByte();
        if (encoding == 0) {
            return new ExtensionObject((ByteString)null, encodingTypeId);
        }
        if (encoding == 1) {
            ByteString byteString = this.decodeByteString(null);
            return new ExtensionObject(byteString, encodingTypeId);
        }
        if (encoding == 2) {
            XmlElement xmlElement = this.decodeXmlElement(null);
            return new ExtensionObject(xmlElement, encodingTypeId);
        }
        throw new UaSerializationException(0x80070000L, "unknown ExtensionObject encoding: " + encoding);
    }

    @Override
    public DataValue decodeDataValue(String field) throws UaSerializationException {
        int mask = this.buffer.readByte() & 0xF;
        Variant value = (mask & 1) == 1 ? this.decodeVariant(null) : Variant.NULL_VALUE;
        StatusCode status = (mask & 2) == 2 ? this.decodeStatusCode(null) : StatusCode.GOOD;
        DateTime sourceTime = (mask & 4) == 4 ? this.decodeDateTime(null) : DateTime.MIN_VALUE;
        DateTime serverTime = (mask & 8) == 8 ? this.decodeDateTime(null) : DateTime.MIN_VALUE;
        return new DataValue(value, status, sourceTime, serverTime);
    }

    @Override
    public Variant decodeVariant(String field) throws UaSerializationException {
        boolean arrayEncoded;
        byte encodingMask = this.buffer.readByte();
        if (encodingMask == 0) {
            return new Variant(null);
        }
        int typeId = encodingMask & 0x3F;
        boolean dimensionsEncoded = (encodingMask & 0x40) == 64;
        boolean bl = arrayEncoded = (encodingMask & 0x80) == 128;
        if (arrayEncoded) {
            int[] nArray;
            Class<?> backingClass = TypeUtil.getBackingClass(typeId);
            int length = this.decodeInt32(null);
            if (length == -1) {
                return new Variant(null);
            }
            if (length > this.maxArrayLength) {
                throw new UaSerializationException(0x80080000L, String.format("max array length exceeded (length=%s, max=%s)", length, this.maxArrayLength));
            }
            Object flatArray = Array.newInstance(backingClass, length);
            for (int i = 0; i < length; ++i) {
                Object element = this.decodeBuiltinType(typeId);
                Array.set(flatArray, i, element);
            }
            if (dimensionsEncoded) {
                nArray = this.decodeDimensions();
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = length;
            }
            int[] dimensions = nArray;
            Object array = dimensions.length > 1 ? ArrayUtil.unflatten(flatArray, dimensions) : flatArray;
            return new Variant(array);
        }
        Object value = this.decodeBuiltinType(typeId);
        return new Variant(value);
    }

    @Override
    public DiagnosticInfo decodeDiagnosticInfo(String field) throws UaSerializationException {
        byte mask = this.buffer.readByte();
        if (mask == 0) {
            return null;
        }
        int symbolicId = (mask & 1) == 1 ? this.decodeInt32(null) : -1;
        int namespaceUri = (mask & 2) == 2 ? this.decodeInt32(null) : -1;
        int localizedText = (mask & 4) == 4 ? this.decodeInt32(null) : -1;
        int locale = (mask & 8) == 8 ? this.decodeInt32(null) : -1;
        String additionalInfo = (mask & 0x10) == 16 ? this.decodeString(null) : null;
        StatusCode innerStatusCode = (mask & 0x20) == 32 ? this.decodeStatusCode(null) : null;
        DiagnosticInfo innerDiagnosticInfo = (mask & 0x40) == 64 ? this.decodeDiagnosticInfo(null) : null;
        return new DiagnosticInfo(namespaceUri, symbolicId, locale, localizedText, additionalInfo, innerStatusCode, innerDiagnosticInfo);
    }

    @Override
    public <T extends UaStructure> T decodeMessage(String field) throws UaSerializationException {
        NodeId encodingId = this.decodeNodeId(null);
        DecoderDelegate delegate = DELEGATE_REGISTRY.getDecoder(encodingId);
        return (T)((UaStructure)delegate.decode(this));
    }

    @Override
    public <T extends UaEnumeration> T decodeEnumeration(String field, Class<T> clazz) throws UaSerializationException {
        DecoderDelegate<T> delegate = DELEGATE_REGISTRY.getDecoder(clazz);
        return (T)((UaEnumeration)delegate.decode(this));
    }

    @Override
    public <T extends UaSerializable> T decodeSerializable(String field, Class<T> clazz) throws UaSerializationException {
        DecoderDelegate<T> delegate = DELEGATE_REGISTRY.getDecoder(clazz);
        return (T)((UaSerializable)delegate.decode(this));
    }

    @Override
    public <T> T[] decodeArray(String field, Function<String, T> decoder, Class<T> clazz) throws UaSerializationException {
        int length = this.decodeInt32(null);
        if (length == -1) {
            return null;
        }
        if (length > this.maxArrayLength) {
            throw new UaSerializationException(0x80080000L, String.format("max array length exceeded (length=%s, max=%s)", length, this.maxArrayLength));
        }
        Object array = Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, decoder.apply(null));
        }
        return (Object[])array;
    }

    @Override
    public <T> T[] decodeArray(String field, BiFunction<String, Class<T>, T> decoder, Class<T> clazz) throws UaSerializationException {
        int length = this.decodeInt32(null);
        if (length == -1) {
            return null;
        }
        if (length > this.maxArrayLength) {
            throw new UaSerializationException(0x80080000L, String.format("max array length exceeded (length=%s, max=%s)", length, this.maxArrayLength));
        }
        Object[] array = (Object[])Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            array[i] = decoder.apply(null, clazz);
        }
        return array;
    }

    private int[] decodeDimensions() {
        int length = this.decodeInt32(null);
        if (length == -1) {
            return new int[0];
        }
        int[] is = new int[length];
        for (int i = 0; i < length; ++i) {
            is[i] = this.decodeInt32(null);
        }
        return is;
    }

    private Object decodeBuiltinType(int typeId) throws UaSerializationException {
        switch (typeId) {
            case 1: {
                return this.decodeBoolean(null);
            }
            case 2: {
                return this.decodeSByte(null);
            }
            case 3: {
                return this.decodeByte(null);
            }
            case 4: {
                return this.decodeInt16(null);
            }
            case 5: {
                return this.decodeUInt16(null);
            }
            case 6: {
                return this.decodeInt32(null);
            }
            case 7: {
                return this.decodeUInt32(null);
            }
            case 8: {
                return this.decodeInt64(null);
            }
            case 9: {
                return this.decodeUInt64(null);
            }
            case 10: {
                return this.decodeFloat(null);
            }
            case 11: {
                return this.decodeDouble(null);
            }
            case 12: {
                return this.decodeString(null);
            }
            case 13: {
                return this.decodeDateTime(null);
            }
            case 14: {
                return this.decodeGuid(null);
            }
            case 15: {
                return this.decodeByteString(null);
            }
            case 16: {
                return this.decodeXmlElement(null);
            }
            case 17: {
                return this.decodeNodeId(null);
            }
            case 18: {
                return this.decodeExpandedNodeId(null);
            }
            case 19: {
                return this.decodeStatusCode(null);
            }
            case 20: {
                return this.decodeQualifiedName(null);
            }
            case 21: {
                return this.decodeLocalizedText(null);
            }
            case 22: {
                return this.decodeExtensionObject(null);
            }
            case 23: {
                return this.decodeDataValue(null);
            }
            case 24: {
                return this.decodeVariant(null);
            }
            case 25: {
                return this.decodeDiagnosticInfo(null);
            }
        }
        throw new UaSerializationException(0x80070000L, "unknown builtin type: " + typeId);
    }
}

