/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;

public class TcpMessageEncoder {
    public static ByteBuf encode(HelloMessage helloMessage) throws UaException {
        return TcpMessageEncoder.encode(MessageType.Hello, b -> HelloMessage.encode(helloMessage, b), Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN));
    }

    public static ByteBuf encode(AcknowledgeMessage acknowledgeMessage) throws UaException {
        return TcpMessageEncoder.encode(MessageType.Acknowledge, b -> AcknowledgeMessage.encode(acknowledgeMessage, b), Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN));
    }

    public static ByteBuf encode(ErrorMessage errorMessage) throws UaException {
        return TcpMessageEncoder.encode(MessageType.Error, b -> ErrorMessage.encode(errorMessage, b), Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN));
    }

    private static ByteBuf encode(MessageType messageType, Consumer<ByteBuf> messageEncoder, ByteBuf buffer) throws UaException {
        buffer.writeMedium(MessageType.toMediumInt(messageType));
        buffer.writeByte(70);
        int lengthIndex = buffer.writerIndex();
        buffer.writeInt(0);
        int indexBefore = buffer.writerIndex();
        messageEncoder.accept(buffer);
        int indexAfter = buffer.writerIndex();
        int bytesWritten = indexAfter - indexBefore;
        buffer.writerIndex(lengthIndex);
        buffer.writeInt(8 + bytesWritten);
        buffer.writerIndex(indexAfter);
        return buffer;
    }
}

