/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryEncoder;
import org.eclipse.milo.opcua.stack.core.util.annotations.UInt32Primitive;

public class HelloMessage {
    @UInt32Primitive
    private final long protocolVersion;
    @UInt32Primitive
    private final long receiveBufferSize;
    @UInt32Primitive
    private final long sendBufferSize;
    @UInt32Primitive
    private final long maxMessageSize;
    @UInt32Primitive
    private final long maxChunkCount;
    private final String endpointUrl;

    public HelloMessage(@UInt32Primitive long protocolVersion, @UInt32Primitive long receiveBufferSize, @UInt32Primitive long sendBufferSize, @UInt32Primitive long maxMessageSize, @UInt32Primitive long maxChunkCount, @Nonnull String endpointUrl) {
        Preconditions.checkArgument((receiveBufferSize >= 8192L ? 1 : 0) != 0, (Object)"receiverBufferSize must be at least 8192 bytes");
        Preconditions.checkArgument((sendBufferSize >= 8192L ? 1 : 0) != 0, (Object)"sendBufferSize must be at least 8192 bytes");
        Preconditions.checkArgument((endpointUrl.length() <= 4096 ? 1 : 0) != 0, (Object)"endpointUrl length cannot be greater than 4096 bytes");
        this.protocolVersion = protocolVersion;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.maxMessageSize = maxMessageSize;
        this.maxChunkCount = maxChunkCount;
        this.endpointUrl = endpointUrl;
    }

    @UInt32Primitive
    public long getProtocolVersion() {
        return this.protocolVersion;
    }

    @UInt32Primitive
    public long getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @UInt32Primitive
    public long getSendBufferSize() {
        return this.sendBufferSize;
    }

    @UInt32Primitive
    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @UInt32Primitive
    public long getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return this.maxChunkCount == that.maxChunkCount && this.maxMessageSize == that.maxMessageSize && this.protocolVersion == that.protocolVersion && this.receiveBufferSize == that.receiveBufferSize && this.sendBufferSize == that.sendBufferSize && this.endpointUrl.equals(that.endpointUrl);
    }

    public int hashCode() {
        int result = (int)(this.protocolVersion ^ this.protocolVersion >>> 32);
        result = 31 * result + (int)(this.receiveBufferSize ^ this.receiveBufferSize >>> 32);
        result = 31 * result + (int)(this.sendBufferSize ^ this.sendBufferSize >>> 32);
        result = 31 * result + (int)(this.maxMessageSize ^ this.maxMessageSize >>> 32);
        result = 31 * result + (int)(this.maxChunkCount ^ this.maxChunkCount >>> 32);
        result = 31 * result + this.endpointUrl.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocolVersion", this.protocolVersion).add("receiverBufferSize", this.receiveBufferSize).add("sendBufferSize", this.sendBufferSize).add("maxMessageSize", this.maxMessageSize).add("maxChunkCount", this.maxChunkCount).add("endpointUrl", (Object)this.endpointUrl).toString();
    }

    public static void encode(HelloMessage message, ByteBuf buffer) {
        buffer.writeInt((int)message.getProtocolVersion());
        buffer.writeInt((int)message.getReceiveBufferSize());
        buffer.writeInt((int)message.getSendBufferSize());
        buffer.writeInt((int)message.getMaxMessageSize());
        buffer.writeInt((int)message.getMaxChunkCount());
        HelloMessage.encodeString(message.getEndpointUrl(), buffer);
    }

    public static HelloMessage decode(ByteBuf buffer) {
        return new HelloMessage(buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt(), buffer.readUnsignedInt(), HelloMessage.decodeString(buffer));
    }

    private static void encodeString(String s, ByteBuf buffer) {
        new BinaryEncoder().setBuffer(buffer).encodeString(null, s);
    }

    private static String decodeString(ByteBuf buffer) {
        return new BinaryDecoder().setBuffer(buffer).decodeString(null);
    }
}

