/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryEncoder;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;

public class SerializationQueue {
    private final BinaryEncoder binaryEncoder;
    private final BinaryDecoder binaryDecoder;
    private final ChunkEncoder chunkEncoder;
    private final ChunkDecoder chunkDecoder;
    private final ExecutionQueue encodingQueue;
    private final ExecutionQueue decodingQueue;
    private final ChannelParameters parameters;

    public SerializationQueue(ExecutorService executor, ChannelParameters parameters, int maxArrayLength, int maxStringLength) {
        this.parameters = parameters;
        this.binaryEncoder = new BinaryEncoder(maxArrayLength, maxStringLength);
        this.binaryDecoder = new BinaryDecoder(maxArrayLength, maxStringLength);
        this.chunkEncoder = new ChunkEncoder(parameters);
        this.chunkDecoder = new ChunkDecoder(parameters);
        this.encodingQueue = new ExecutionQueue(executor);
        this.decodingQueue = new ExecutionQueue(executor);
    }

    public void encode(BiConsumer<BinaryEncoder, ChunkEncoder> consumer) {
        this.encodingQueue.submit(() -> consumer.accept(this.binaryEncoder, this.chunkEncoder));
    }

    public void decode(BiConsumer<BinaryDecoder, ChunkDecoder> consumer) {
        this.decodingQueue.submit(() -> consumer.accept(this.binaryDecoder, this.chunkDecoder));
    }

    public void pause() {
        this.encodingQueue.pause();
        this.decodingQueue.pause();
    }

    public ChannelParameters getParameters() {
        return this.parameters;
    }
}

