/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public interface SecureChannel {
    public KeyPair getKeyPair();

    public X509Certificate getLocalCertificate();

    public X509Certificate getRemoteCertificate();

    public List<X509Certificate> getRemoteCertificateChain();

    public SecurityPolicy getSecurityPolicy();

    public MessageSecurityMode getMessageSecurityMode();

    public long getChannelId();

    public ChannelSecurity getChannelSecurity();

    public ChannelSecurity.SecretKeys getEncryptionKeys(ChannelSecurity.SecuritySecrets var1);

    public ChannelSecurity.SecretKeys getDecryptionKeys(ChannelSecurity.SecuritySecrets var1);

    public ByteString getLocalNonce();

    public ByteString getRemoteNonce();

    default public ByteString getLocalCertificateBytes() throws UaException {
        try {
            return this.getLocalCertificate() != null ? ByteString.of(this.getLocalCertificate().getEncoded()) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getLocalCertificateThumbprint() throws UaException {
        try {
            return this.getLocalCertificate() != null ? ByteString.of(DigestUtil.sha1(this.getLocalCertificate().getEncoded())) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getRemoteCertificateBytes() throws UaException {
        try {
            return this.getRemoteCertificate() != null ? ByteString.of(this.getRemoteCertificate().getEncoded()) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public ByteString getRemoteCertificateThumbprint() throws UaException {
        try {
            return this.getRemoteCertificate() != null ? ByteString.of(DigestUtil.sha1(this.getRemoteCertificate().getEncoded())) : ByteString.NULL_VALUE;
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    default public int getLocalAsymmetricCipherTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Rsa15: 
                case RsaOaep: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getLocalCertificate()) + 1) / 8;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getRemoteAsymmetricCipherTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Rsa15: 
                case RsaOaep: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getRemoteCertificate()) + 1) / 8;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getLocalAsymmetricPlainTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Rsa15: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getLocalCertificate()) + 1) / 8 - 11;
                }
                case RsaOaep: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getLocalCertificate()) + 1) / 8 - 42;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getRemoteAsymmetricPlainTextBlockSize() {
        if (this.isAsymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Rsa15: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getRemoteCertificate()) + 1) / 8 - 11;
                }
                case RsaOaep: {
                    return (SecureChannel.getAsymmetricKeyLength(this.getRemoteCertificate()) + 1) / 8 - 42;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getLocalAsymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        switch (algorithm) {
            case RsaSha1: 
            case RsaSha256: {
                return (SecureChannel.getAsymmetricKeyLength(this.getLocalCertificate()) + 1) / 8;
            }
        }
        return 0;
    }

    default public int getRemoteAsymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        switch (algorithm) {
            case RsaSha1: 
            case RsaSha256: {
                return (SecureChannel.getAsymmetricKeyLength(this.getRemoteCertificate()) + 1) / 8;
            }
        }
        return 0;
    }

    default public boolean isAsymmetricSigningEnabled() {
        return this.getSecurityPolicy() != SecurityPolicy.None && this.getLocalCertificate() != null;
    }

    default public boolean isAsymmetricEncryptionEnabled() {
        return this.getSecurityPolicy() != SecurityPolicy.None && this.getLocalCertificate() != null && this.getRemoteCertificate() != null;
    }

    default public int getSymmetricCipherTextBlockSize() {
        if (this.isSymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Aes128: 
                case Aes256: {
                    return 16;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getSymmetricPlainTextBlockSize() {
        if (this.isSymmetricEncryptionEnabled()) {
            SecurityAlgorithm algorithm = this.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
            switch (algorithm) {
                case Aes128: 
                case Aes256: {
                    return 16;
                }
            }
            return 1;
        }
        return 1;
    }

    default public int getSymmetricSignatureSize() {
        SecurityAlgorithm algorithm = this.getSecurityPolicy().getSymmetricSignatureAlgorithm();
        switch (algorithm) {
            case HmacSha1: {
                return 20;
            }
            case HmacSha256: {
                return 32;
            }
        }
        return 0;
    }

    default public int getSymmetricSignatureKeySize() {
        switch (this.getSecurityPolicy()) {
            case None: {
                return 0;
            }
            case Basic128Rsa15: {
                return 16;
            }
            case Basic256: {
                return 24;
            }
            case Basic256Sha256: {
                return 32;
            }
        }
        return 0;
    }

    default public int getSymmetricEncryptionKeySize() {
        switch (this.getSecurityPolicy()) {
            case None: {
                return 0;
            }
            case Basic128Rsa15: {
                return 16;
            }
            case Basic256: 
            case Basic256Sha256: {
                return 32;
            }
        }
        return 0;
    }

    default public boolean isSymmetricSigningEnabled() {
        return this.getLocalCertificate() != null && this.getSecurityPolicy() != SecurityPolicy.None && (this.getMessageSecurityMode() == MessageSecurityMode.Sign || this.getMessageSecurityMode() == MessageSecurityMode.SignAndEncrypt);
    }

    default public boolean isSymmetricEncryptionEnabled() {
        return this.getRemoteCertificate() != null && this.getSecurityPolicy() != SecurityPolicy.None && this.getMessageSecurityMode() == MessageSecurityMode.SignAndEncrypt;
    }

    public static int getAsymmetricKeyLength(Certificate certificate) {
        PublicKey publicKey = certificate != null ? certificate.getPublicKey() : null;
        return publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : 0;
    }
}

