/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.util.PShaUtil;

public class ChannelSecurity {
    private final SecuritySecrets currentKeys;
    private final ChannelSecurityToken currentToken;
    private final Optional<SecuritySecrets> previousKeys;
    private final Optional<ChannelSecurityToken> previousToken;

    public ChannelSecurity(SecuritySecrets currentSecuritySecrets, ChannelSecurityToken currentToken) {
        this(currentSecuritySecrets, currentToken, null, null);
    }

    public ChannelSecurity(SecuritySecrets currentKeys, ChannelSecurityToken currentToken, SecuritySecrets previousKeys, ChannelSecurityToken previousToken) {
        this.currentKeys = currentKeys;
        this.currentToken = currentToken;
        this.previousKeys = Optional.ofNullable(previousKeys);
        this.previousToken = Optional.ofNullable(previousToken);
    }

    public SecuritySecrets getCurrentKeys() {
        return this.currentKeys;
    }

    public ChannelSecurityToken getCurrentToken() {
        return this.currentToken;
    }

    public Optional<SecuritySecrets> getPreviousKeys() {
        return this.previousKeys;
    }

    public Optional<ChannelSecurityToken> getPreviousToken() {
        return this.previousToken;
    }

    public static SecuritySecrets generateKeyPair(SecureChannel channel, ByteString clientNonce, ByteString serverNonce) {
        SecurityAlgorithm keyDerivation = channel.getSecurityPolicy().getKeyDerivationAlgorithm();
        int signatureKeySize = channel.getSymmetricSignatureKeySize();
        int encryptionKeySize = channel.getSymmetricEncryptionKeySize();
        int cipherTextBlockSize = channel.getSymmetricCipherTextBlockSize();
        assert (clientNonce != null);
        assert (serverNonce != null);
        byte[] clientSignatureKey = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(serverNonce.bytes(), clientNonce.bytes(), 0, signatureKeySize) : PShaUtil.createPSha256Key(serverNonce.bytes(), clientNonce.bytes(), 0, signatureKeySize);
        byte[] clientEncryptionKey = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(serverNonce.bytes(), clientNonce.bytes(), signatureKeySize, encryptionKeySize) : PShaUtil.createPSha256Key(serverNonce.bytes(), clientNonce.bytes(), signatureKeySize, encryptionKeySize);
        byte[] clientInitializationVector = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(serverNonce.bytes(), clientNonce.bytes(), signatureKeySize + encryptionKeySize, cipherTextBlockSize) : PShaUtil.createPSha256Key(serverNonce.bytes(), clientNonce.bytes(), signatureKeySize + encryptionKeySize, cipherTextBlockSize);
        byte[] serverSignatureKey = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(clientNonce.bytes(), serverNonce.bytes(), 0, signatureKeySize) : PShaUtil.createPSha256Key(clientNonce.bytes(), serverNonce.bytes(), 0, signatureKeySize);
        byte[] serverEncryptionKey = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(clientNonce.bytes(), serverNonce.bytes(), signatureKeySize, encryptionKeySize) : PShaUtil.createPSha256Key(clientNonce.bytes(), serverNonce.bytes(), signatureKeySize, encryptionKeySize);
        byte[] serverInitializationVector = keyDerivation == SecurityAlgorithm.PSha1 ? PShaUtil.createPSha1Key(clientNonce.bytes(), serverNonce.bytes(), signatureKeySize + encryptionKeySize, cipherTextBlockSize) : PShaUtil.createPSha256Key(clientNonce.bytes(), serverNonce.bytes(), signatureKeySize + encryptionKeySize, cipherTextBlockSize);
        return new SecuritySecrets(new SecretKeys(clientSignatureKey, clientEncryptionKey, clientInitializationVector), new SecretKeys(serverSignatureKey, serverEncryptionKey, serverInitializationVector));
    }

    public static class SecretKeys {
        private final byte[] signatureKey;
        private final byte[] encryptionKey;
        private final byte[] initializationVector;

        public SecretKeys(byte[] signatureKey, byte[] encryptionKey, byte[] initializationVector) {
            this.signatureKey = signatureKey;
            this.encryptionKey = encryptionKey;
            this.initializationVector = initializationVector;
        }

        public byte[] getSignatureKey() {
            return this.signatureKey;
        }

        public byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        public byte[] getInitializationVector() {
            return this.initializationVector;
        }
    }

    public static class SecuritySecrets {
        private final SecretKeys clientKeys;
        private final SecretKeys serverKeys;

        public SecuritySecrets(SecretKeys clientKeys, SecretKeys serverKeys) {
            this.clientKeys = clientKeys;
            this.serverKeys = serverKeys;
        }

        public SecretKeys getClientKeys() {
            return this.clientKeys;
        }

        public SecretKeys getServerKeys() {
            return this.serverKeys;
        }
    }
}

