/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import com.google.common.base.Preconditions;

public class ChannelConfig {
    public static final ChannelConfig DEFAULT = new ChannelConfig();
    public static final int DEFAULT_MAX_CHUNK_SIZE = 65536;
    public static final int DEFAULT_MAX_CHUNK_COUNT = 32;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    public static final int DEFAULT_MAX_ARRAY_LENGTH = 65536;
    public static final int DEFAULT_MAX_STRING_LENGTH = 65536;
    private final int maxChunkSize;
    private final int maxChunkCount;
    private final int maxMessageSize;
    private final int maxArrayLength;
    private final int maxStringLength;

    public ChannelConfig() {
        this(65536, 32, 0x200000, 65536, 65536);
    }

    public ChannelConfig(int maxChunkSize, int maxChunkCount, int maxMessageSize, int maxArrayLength, int maxStringLength) {
        Preconditions.checkArgument((maxChunkSize >= 8192 ? 1 : 0) != 0, (Object)"maxChunkSize must be greater than or equal to 8192");
        this.maxChunkSize = maxChunkSize;
        this.maxChunkCount = maxChunkCount;
        this.maxMessageSize = maxMessageSize;
        this.maxArrayLength = maxArrayLength;
        this.maxStringLength = maxStringLength;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }
}

