/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.AttributeKey;
import io.netty.util.Timeout;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.client.handlers.UaRequestFuture;
import org.eclipse.milo.opcua.stack.client.handlers.UaTcpClientAcknowledgeHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortedException;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryDecoder;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpClientMessageHandler
extends ByteToMessageCodec<UaRequestFuture>
implements HeaderDecoder {
    public static final AttributeKey<Map<Long, UaRequestFuture>> KEY_PENDING_REQUEST_FUTURES = AttributeKey.valueOf((String)"pending-request-futures");
    public static final int SECURE_CHANNEL_TIMEOUT_SECONDS = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ByteBuf> chunkBuffers = new LinkedList<ByteBuf>();
    private final AtomicReference<AsymmetricSecurityHeader> headerRef = new AtomicReference();
    private ScheduledFuture renewFuture;
    private Timeout secureChannelTimeout;
    private final Map<Long, UaRequestFuture> pending;
    private final LongSequence requestIdSequence;
    private final UaTcpStackClient client;
    private final ClientSecureChannel secureChannel;
    private final SerializationQueue serializationQueue;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;

    public UaTcpClientMessageHandler(UaTcpStackClient client, ClientSecureChannel secureChannel, SerializationQueue serializationQueue, CompletableFuture<ClientSecureChannel> handshakeFuture) {
        this.client = client;
        this.secureChannel = secureChannel;
        this.serializationQueue = serializationQueue;
        this.handshakeFuture = handshakeFuture;
        secureChannel.attr(KEY_PENDING_REQUEST_FUTURES).setIfAbsent((Object)Maps.newConcurrentMap());
        this.pending = (Map)secureChannel.attr(KEY_PENDING_REQUEST_FUTURES).get();
        secureChannel.attr(ClientSecureChannel.KEY_REQUEST_ID_SEQUENCE).setIfAbsent((Object)new LongSequence(1L, 0xFFFFFFFFL));
        this.requestIdSequence = (LongSequence)secureChannel.attr(ClientSecureChannel.KEY_REQUEST_ID_SEQUENCE).get();
        handshakeFuture.thenAccept(sc -> {
            Channel channel = sc.getChannel();
            channel.eventLoop().execute(() -> {
                List awaitingHandshake = (List)channel.attr(UaTcpClientAcknowledgeHandler.KEY_AWAITING_HANDSHAKE).get();
                if (awaitingHandshake != null) {
                    channel.attr(UaTcpClientAcknowledgeHandler.KEY_AWAITING_HANDSHAKE).remove();
                    this.logger.debug("{} message(s) queued before handshake completed; sending now.", (Object)awaitingHandshake.size());
                    awaitingHandshake.forEach(arg_0 -> ((Channel)channel).writeAndFlush(arg_0));
                }
            });
        });
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        SecurityTokenRequestType requestType = this.secureChannel.getChannelId() == 0L ? SecurityTokenRequestType.Issue : SecurityTokenRequestType.Renew;
        this.secureChannelTimeout = this.client.getConfig().getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
            }
        }, 10L, TimeUnit.SECONDS);
        this.logger.debug("OpenSecureChannel timeout scheduled for +5s");
        this.sendOpenSecureChannelRequest(ctx, requestType);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.renewFuture != null) {
            this.renewFuture.cancel(false);
        }
        this.handshakeFuture.completeExceptionally(new UaException(2158886912L, "connection closed"));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.error("[remote={}] Exception caught: {}", new Object[]{ctx.channel().remoteAddress(), cause.getMessage(), cause});
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof CloseSecureChannelRequest) {
            this.sendCloseSecureChannelRequest(ctx, (CloseSecureChannelRequest)evt);
        }
    }

    private void sendOpenSecureChannelRequest(ChannelHandlerContext ctx, SecurityTokenRequestType requestType) {
        SecurityAlgorithm algorithm = this.secureChannel.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
        int nonceLength = NonceUtil.getNonceLength(algorithm);
        ByteString clientNonce = this.secureChannel.isSymmetricSigningEnabled() ? NonceUtil.generateNonce(nonceLength) : ByteString.NULL_VALUE;
        this.secureChannel.setLocalNonce(clientNonce);
        OpenSecureChannelRequest request = new OpenSecureChannelRequest(new RequestHeader(null, DateTime.now(), Unsigned.uint(0), Unsigned.uint(0), null, Unsigned.uint(0), null), Unsigned.uint(0L), requestType, this.secureChannel.getMessageSecurityMode(), this.secureChannel.getLocalNonce(), this.client.getChannelLifetime());
        this.encodeMessage(request, MessageType.OpenSecureChannel).whenComplete((t2, ex) -> {
            if (ex != null) {
                ctx.close();
                return;
            }
            List chunks = (List)t2.v2();
            ctx.executor().execute(() -> {
                chunks.forEach(c -> ctx.write(c, ctx.voidPromise()));
                ctx.flush();
            });
            ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
            long currentTokenId = channelSecurity != null ? channelSecurity.getCurrentToken().getTokenId().longValue() : -1L;
            long previousTokenId = channelSecurity != null ? channelSecurity.getPreviousToken().map(token -> token.getTokenId().longValue()).orElse(-1L) : -1L;
            this.logger.debug("Sent OpenSecureChannelRequest ({}, id={}, currentToken={}, previousToken={}).", new Object[]{request.getRequestType(), this.secureChannel.getChannelId(), currentTokenId, previousTokenId});
        });
    }

    private void sendCloseSecureChannelRequest(ChannelHandlerContext ctx, CloseSecureChannelRequest request) {
        this.encodeMessage(request, MessageType.CloseSecureChannel).whenComplete((t2, ex) -> {
            if (ex != null) {
                ctx.close();
                return;
            }
            List chunks = (List)t2.v2();
            ctx.executor().execute(() -> {
                chunks.forEach(c -> ctx.write(c, ctx.voidPromise()));
                ctx.flush();
                ctx.close();
            });
            this.secureChannel.setChannelId(0L);
        });
    }

    protected void encode(ChannelHandlerContext ctx, UaRequestFuture request, ByteBuf buffer) throws Exception {
        this.encodeMessage(request.getRequest(), MessageType.SecureMessage).whenComplete((t2, ex) -> {
            if (ex != null) {
                ctx.close();
                return;
            }
            long requestId = (Long)t2.v1();
            List chunks = (List)t2.v2();
            this.pending.put(requestId, request);
            request.getFuture().whenComplete((r, x) -> this.pending.remove(requestId));
            ctx.executor().execute(() -> {
                chunks.forEach(c -> ctx.write(c, ctx.voidPromise()));
                ctx.flush();
            });
        });
    }

    private CompletableFuture<Tuple2<Long, List<ByteBuf>>> encodeMessage(UaRequestMessage request, MessageType messageType) {
        CompletableFuture<Tuple2<Long, List<ByteBuf>>> future = new CompletableFuture<Tuple2<Long, List<ByteBuf>>>();
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = null;
            try {
                messageBuffer = BufferUtil.buffer();
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.encodeMessage(null, request);
                List<ByteBuf> chunks = messageType == MessageType.OpenSecureChannel ? chunkEncoder.encodeAsymmetric(this.secureChannel, messageType, messageBuffer, this.requestIdSequence.getAndIncrement()) : chunkEncoder.encodeSymmetric(this.secureChannel, messageType, messageBuffer, this.requestIdSequence.getAndIncrement());
                future.complete(new Tuple2((Object)chunkEncoder.getLastRequestId(), chunks));
            }
            catch (UaException ex) {
                this.logger.error("Error encoding {}: {}", new Object[]{request, ex.getMessage(), ex});
                future.completeExceptionally(ex);
            }
            finally {
                if (messageBuffer != null) {
                    messageBuffer.release();
                }
            }
        });
        return future;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8 && (buffer = buffer.order(ByteOrder.LITTLE_ENDIAN)).readableBytes() >= this.getMessageLength(buffer)) {
            this.decodeMessage(ctx, buffer);
        }
    }

    private void decodeMessage(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        int messageLength = this.getMessageLength(buffer);
        MessageType messageType = MessageType.fromMediumInt(buffer.getMedium(buffer.readerIndex()));
        switch (messageType) {
            case OpenSecureChannel: {
                this.onOpenSecureChannel(ctx, buffer.readSlice(messageLength));
                break;
            }
            case SecureMessage: {
                this.onSecureMessage(ctx, buffer.readSlice(messageLength));
                break;
            }
            case Error: {
                this.onError(ctx, buffer.readSlice(messageLength));
                break;
            }
            default: {
                throw new UaException(2155741184L, "unexpected MessageType: " + (Object)((Object)messageType));
            }
        }
    }

    private boolean accumulateChunk(ByteBuf buffer) throws UaException {
        int maxChunkCount = this.serializationQueue.getParameters().getLocalMaxChunkCount();
        int maxChunkSize = this.serializationQueue.getParameters().getLocalReceiveBufferSize();
        int chunkSize = buffer.readerIndex(0).readableBytes();
        if (chunkSize > maxChunkSize) {
            throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", maxChunkSize));
        }
        this.chunkBuffers.add(buffer.retain());
        if (this.chunkBuffers.size() > maxChunkCount) {
            throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", maxChunkCount));
        }
        char chunkType = (char)buffer.getByte(3);
        return chunkType == 'A' || chunkType == 'F';
    }

    private void onOpenSecureChannel(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        if (this.secureChannelTimeout != null) {
            if (this.secureChannelTimeout.cancel()) {
                this.logger.debug("OpenSecureChannel timeout canceled");
                this.secureChannelTimeout = null;
            } else {
                this.logger.warn("timed out waiting for secure channel");
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
                return;
            }
        }
        buffer.skipBytes(12);
        AsymmetricSecurityHeader securityHeader = AsymmetricSecurityHeader.decode(buffer);
        if (!this.headerRef.compareAndSet(null, securityHeader) && !securityHeader.equals(this.headerRef.get())) {
            throw new UaException(2148728832L, "subsequent AsymmetricSecurityHeader did not match");
        }
        if (this.accumulateChunk(buffer)) {
            ImmutableList buffersToDecode = ImmutableList.copyOf(this.chunkBuffers);
            this.chunkBuffers = new LinkedList<ByteBuf>();
            this.serializationQueue.decode((arg_0, arg_1) -> this.lambda$onOpenSecureChannel$15((List)buffersToDecode, ctx, arg_0, arg_1));
        }
    }

    private void installSecurityToken(ChannelHandlerContext ctx, OpenSecureChannelResponse response) {
        ChannelSecurity oldSecrets;
        ChannelSecurity.SecuritySecrets newKeys = null;
        if (response.getServerProtocolVersion().longValue() < 0L) {
            throw new UaRuntimeException(2159935488L, "server protocol version unsupported: " + response.getServerProtocolVersion());
        }
        ChannelSecurityToken newToken = response.getSecurityToken();
        if (this.secureChannel.isSymmetricSigningEnabled()) {
            this.secureChannel.setRemoteNonce(response.getServerNonce());
            newKeys = ChannelSecurity.generateKeyPair(this.secureChannel, this.secureChannel.getLocalNonce(), this.secureChannel.getRemoteNonce());
        }
        ChannelSecurity.SecuritySecrets oldKeys = (oldSecrets = this.secureChannel.getChannelSecurity()) != null ? oldSecrets.getCurrentKeys() : null;
        ChannelSecurityToken oldToken = oldSecrets != null ? oldSecrets.getCurrentToken() : null;
        this.secureChannel.setChannelSecurity(new ChannelSecurity(newKeys, newToken, oldKeys, oldToken));
        DateTime createdAt = response.getSecurityToken().getCreatedAt();
        long revisedLifetime = response.getSecurityToken().getRevisedLifetime().longValue();
        if (revisedLifetime > 0L) {
            long renewAt = (long)((double)revisedLifetime * 0.75);
            this.renewFuture = ctx.executor().schedule(() -> this.sendOpenSecureChannelRequest(ctx, SecurityTokenRequestType.Renew), renewAt, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("Server revised secure channel lifetime to 0; renewal will not occur.");
        }
        ctx.executor().execute(() -> {
            if (ctx.pipeline().get(UaTcpClientAcknowledgeHandler.class) != null) {
                ctx.pipeline().remove(UaTcpClientAcknowledgeHandler.class);
            }
        });
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        this.logger.debug("SecureChannel id={}, currentTokenId={}, previousTokenId={}, lifetime={}ms, createdAt={}", new Object[]{this.secureChannel.getChannelId(), currentTokenId, previousTokenId, revisedLifetime, createdAt});
    }

    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        buffer.skipBytes(8);
        long secureChannelId = buffer.readUnsignedInt();
        if (secureChannelId != this.secureChannel.getChannelId()) {
            throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
        }
        if (this.accumulateChunk(buffer)) {
            ImmutableList buffersToDecode = ImmutableList.copyOf(this.chunkBuffers);
            this.chunkBuffers = new LinkedList<ByteBuf>();
            this.serializationQueue.decode((arg_0, arg_1) -> this.lambda$onSecureMessage$21((List)buffersToDecode, ctx, arg_0, arg_1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            boolean secureChannelError;
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError(buffer);
            StatusCode statusCode = errorMessage.getError();
            long errorCode = statusCode.getValue();
            boolean bl = secureChannelError = errorCode == 2148728832L || errorCode == 2155806720L || errorCode == 0x80220000L;
            if (secureChannelError) {
                this.secureChannel.setChannelId(0L);
            }
            this.logger.error("[remote={}] Received error message: {}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
        }
        catch (UaException e) {
            this.logger.error("[remote={}] An exception occurred while decoding an error message: {}", new Object[]{ctx.channel().remoteAddress(), e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$onSecureMessage$21(List buffersToDecode, ChannelHandlerContext ctx, BinaryDecoder binaryDecoder, ChunkDecoder chunkDecoder) {
        ByteBuf decodedBuffer = null;
        try {
            decodedBuffer = chunkDecoder.decodeSymmetric(this.secureChannel, buffersToDecode);
            binaryDecoder.setBuffer(decodedBuffer);
            UaResponseMessage response = (UaResponseMessage)binaryDecoder.decodeMessage(null);
            UaRequestFuture request = this.pending.remove(chunkDecoder.getLastRequestId());
            if (request != null) {
                this.client.getExecutorService().execute(() -> request.getFuture().complete(response));
            } else {
                this.logger.warn("No UaRequestFuture for requestId={}", (Object)chunkDecoder.getLastRequestId());
            }
        }
        catch (MessageAbortedException e) {
            this.logger.debug("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
            UaRequestFuture request = this.pending.remove(chunkDecoder.getLastRequestId());
            if (request != null) {
                this.client.getExecutorService().execute(() -> request.getFuture().completeExceptionally(e));
            } else {
                this.logger.warn("No UaRequestFuture for requestId={}", (Object)chunkDecoder.getLastRequestId());
            }
        }
        catch (Throwable t) {
            this.logger.error("Error decoding symmetric message: {}", (Object)t.getMessage(), (Object)t);
            this.serializationQueue.pause();
            ctx.close();
        }
        finally {
            if (decodedBuffer != null) {
                decodedBuffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$onOpenSecureChannel$15(List buffersToDecode, ChannelHandlerContext ctx, BinaryDecoder binaryDecoder, ChunkDecoder chunkDecoder) {
        block9: {
            ByteBuf decodedBuffer = null;
            try {
                decodedBuffer = chunkDecoder.decodeAsymmetric(this.secureChannel, buffersToDecode);
                UaResponseMessage responseMessage = (UaResponseMessage)binaryDecoder.setBuffer(decodedBuffer).decodeMessage(null);
                StatusCode serviceResult = responseMessage.getResponseHeader().getServiceResult();
                if (serviceResult.isGood()) {
                    OpenSecureChannelResponse response = (OpenSecureChannelResponse)responseMessage;
                    this.secureChannel.setChannelId(response.getSecurityToken().getChannelId().longValue());
                    this.logger.debug("Received OpenSecureChannelResponse.");
                    this.installSecurityToken(ctx, response);
                    this.handshakeFuture.complete(this.secureChannel);
                    break block9;
                }
                ServiceFault serviceFault = responseMessage instanceof ServiceFault ? (ServiceFault)responseMessage : new ServiceFault(responseMessage.getResponseHeader());
                throw new UaServiceFaultException(serviceFault);
            }
            catch (MessageAbortedException e) {
                this.logger.error("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
                ctx.close();
            }
            catch (Throwable t) {
                this.logger.error("Error decoding OpenSecureChannelResponse: {}", (Object)t.getMessage(), (Object)t);
                ctx.close();
            }
            finally {
                if (decodedBuffer != null) {
                    decodedBuffer.release();
                }
            }
        }
    }
}

