/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.handlers;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.AttributeKey;
import io.netty.util.Timeout;
import java.nio.ByteOrder;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.client.handlers.UaRequestFuture;
import org.eclipse.milo.opcua.stack.client.handlers.UaTcpClientMessageHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.jooq.lambda.tuple.Tuple1;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpClientAcknowledgeHandler
extends ByteToMessageCodec<UaRequestFuture>
implements HeaderDecoder {
    public static final AttributeKey<List<UaRequestFuture>> KEY_AWAITING_HANDSHAKE = AttributeKey.valueOf((String)"awaiting-handshake");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UaRequestFuture> awaitingHandshake = new CopyOnWriteArrayList<UaRequestFuture>();
    private volatile Timeout helloTimeout;
    private final ClientSecureChannel secureChannel;
    private final UaTcpStackClient client;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;

    public UaTcpClientAcknowledgeHandler(UaTcpStackClient client, Optional<ClientSecureChannel> existingChannel, CompletableFuture<ClientSecureChannel> handshakeFuture) {
        this.client = client;
        this.handshakeFuture = handshakeFuture;
        UaTcpStackClientConfig config = client.getConfig();
        this.secureChannel = existingChannel.isPresent() ? existingChannel.get() : config.getEndpoint().flatMap(e -> {
            SecurityPolicy securityPolicy = SecurityPolicy.fromUriSafe(e.getSecurityPolicyUri()).orElse(SecurityPolicy.None);
            if (securityPolicy == SecurityPolicy.None) {
                return Optional.empty();
            }
            return Optional.of(new Tuple1(e));
        }).flatMap(t1 -> config.getKeyPair().map(arg_0 -> ((Tuple1)t1).concat(arg_0))).flatMap(t2 -> config.getCertificate().map(arg_0 -> ((Tuple2)t2).concat(arg_0))).flatMap(t3 -> {
            EndpointDescription endpoint = (EndpointDescription)t3.v1();
            KeyPair keyPair = (KeyPair)t3.v2();
            X509Certificate localCertificate = (X509Certificate)t3.v3();
            try {
                X509Certificate remoteCertificate = CertificateUtil.decodeCertificate(endpoint.getServerCertificate().bytes());
                List<X509Certificate> remoteCertificateChain = CertificateUtil.decodeCertificates(endpoint.getServerCertificate().bytes());
                SecurityPolicy securityPolicy = SecurityPolicy.fromUri(endpoint.getSecurityPolicyUri());
                ClientSecureChannel secureChannel = new ClientSecureChannel(keyPair, localCertificate, remoteCertificate, remoteCertificateChain, securityPolicy, endpoint.getSecurityMode());
                return Optional.of(secureChannel);
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }).orElse(new ClientSecureChannel(SecurityPolicy.None, MessageSecurityMode.None));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.helloTimeout = this.startHelloTimeout(ctx);
        this.secureChannel.setChannel(ctx.channel());
        HelloMessage hello = new HelloMessage(0L, this.client.getChannelConfig().getMaxChunkSize(), this.client.getChannelConfig().getMaxChunkSize(), this.client.getChannelConfig().getMaxMessageSize(), this.client.getChannelConfig().getMaxChunkCount(), this.client.getEndpointUrl());
        ByteBuf messageBuffer = TcpMessageEncoder.encode(hello);
        ctx.writeAndFlush((Object)messageBuffer);
        this.logger.debug("Sent Hello message on channel={}.", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    private Timeout startHelloTimeout(ChannelHandlerContext ctx) {
        return this.client.getConfig().getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
                ctx.close();
            }
        }, 5L, TimeUnit.SECONDS);
    }

    protected void encode(ChannelHandlerContext ctx, UaRequestFuture message, ByteBuf out) throws Exception {
        this.awaitingHandshake.add(message);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block4: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt(buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case Acknowledge: {
                    this.onAcknowledge(ctx, buffer.readSlice(messageLength));
                    continue block4;
                }
                case Error: {
                    this.onError(ctx, buffer.readSlice(messageLength));
                    continue block4;
                }
            }
            out.add(buffer.readSlice(messageLength).retain());
        }
    }

    private void onAcknowledge(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.helloTimeout != null && !this.helloTimeout.cancel()) {
            this.helloTimeout = null;
            this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
            ctx.close();
            return;
        }
        this.logger.debug("Received Acknowledge message on channel={}.", (Object)ctx.channel());
        buffer.skipBytes(8);
        AcknowledgeMessage acknowledge = AcknowledgeMessage.decode(buffer);
        long remoteProtocolVersion = acknowledge.getProtocolVersion();
        long remoteReceiveBufferSize = acknowledge.getReceiveBufferSize();
        long remoteSendBufferSize = acknowledge.getSendBufferSize();
        long remoteMaxMessageSize = acknowledge.getMaxMessageSize();
        long remoteMaxChunkCount = acknowledge.getMaxChunkCount();
        if (0L > remoteProtocolVersion) {
            this.logger.warn("Client protocol version ({}) does not match server protocol version ({}).", (Object)0L, (Object)remoteProtocolVersion);
        }
        ChannelConfig config = this.client.getChannelConfig();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)config.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)config.getMaxChunkSize());
        long localMaxMessageSize = config.getMaxMessageSize();
        long localMaxChunkCount = config.getMaxChunkCount();
        ChannelParameters parameters = new ChannelParameters(Ints.saturatedCast((long)localMaxMessageSize), Ints.saturatedCast((long)localReceiveBufferSize), Ints.saturatedCast((long)localSendBufferSize), Ints.saturatedCast((long)localMaxChunkCount), Ints.saturatedCast((long)remoteMaxMessageSize), Ints.saturatedCast((long)remoteReceiveBufferSize), Ints.saturatedCast((long)remoteSendBufferSize), Ints.saturatedCast((long)remoteMaxChunkCount));
        ctx.channel().attr(KEY_AWAITING_HANDSHAKE).set(this.awaitingHandshake);
        ctx.executor().execute(() -> {
            int maxArrayLength = this.client.getChannelConfig().getMaxArrayLength();
            int maxStringLength = this.client.getChannelConfig().getMaxStringLength();
            SerializationQueue serializationQueue = new SerializationQueue(this.client.getConfig().getExecutor(), parameters, maxArrayLength, maxStringLength);
            UaTcpClientMessageHandler handler = new UaTcpClientMessageHandler(this.client, this.secureChannel, serializationQueue, this.handshakeFuture);
            ctx.pipeline().addLast(new ChannelHandler[]{handler});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            boolean secureChannelError;
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError(buffer);
            StatusCode statusCode = errorMessage.getError();
            long errorCode = statusCode.getValue();
            boolean bl = secureChannelError = errorCode == 2148728832L || errorCode == 2155806720L || errorCode == 0x80220000L;
            if (secureChannelError) {
                this.secureChannel.setChannelId(0L);
            }
            this.logger.error("[remote={}] Received error message: {}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
        }
        catch (UaException e) {
            this.logger.error("[remote={}] An exception occurred while decoding an error message: {}", new Object[]{ctx.channel().remoteAddress(), e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }
}

