/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.enumerated.FilterOperator;
import org.eclipse.milo.opcua.stack.core.types.structured.AttributeOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElement;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class ContentFilterUtil {
    public void apply(ContentFilter filter) throws UaException {
        int i = 0;
        List<ContentFilterElement> elements = ConversionUtil.l(filter.getElements());
        if (i < elements.size()) {
            ContentFilterElement element = elements.get(i);
            FilterOperator operator = element.getFilterOperator();
            SimpleAttributeOperand[] operands = this.extract(element.getFilterOperands());
            throw new UaException(2152267776L);
        }
    }

    private boolean apply(FilterOperator operator, FilterOperand[] operands) {
        if (operator == FilterOperator.Equals) {
            SimpleAttributeOperand op0 = (SimpleAttributeOperand)operands[0];
            AttributeOperand op1 = (AttributeOperand)operands[1];
            op0.getAttributeId();
            op0.getBrowsePath();
            op0.getIndexRange();
            op0.getTypeDefinitionId();
        }
        return false;
    }

    private SimpleAttributeOperand[] extract(ExtensionObject[] operandXos) {
        return (SimpleAttributeOperand[])Arrays.stream(operandXos).map(xo -> (SimpleAttributeOperand)xo.decode()).toArray(SimpleAttributeOperand[]::new);
    }

    private static class EqualsOperator {
        private EqualsOperator() {
        }

        public void apply(FilterOperand[] operands) throws UaException {
        }
    }
}

