/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;

public class AttributeWriter {
    public static void writeAttribute(AttributeContext context, ServerNode node, AttributeId attributeId, DataValue value, @Nullable String indexRange) throws UaException {
        AttributeContext internalContext = new AttributeContext(context.getServer());
        NodeClass nodeClass = node.getNodeClass();
        if (attributeId == AttributeId.Value && nodeClass == NodeClass.Variable) {
            Set<AccessLevel> accessLevels = AttributeUtil.getAccessLevels(node, internalContext);
            if (!accessLevels.contains((Object)AccessLevel.CurrentWrite)) {
                throw new UaException(2151350272L);
            }
            Set<AccessLevel> userAccessLevels = AttributeUtil.getUserAccessLevels(node, context);
            if (!userAccessLevels.contains((Object)AccessLevel.CurrentWrite)) {
                throw new UaException(2149515264L);
            }
        } else {
            WriteMask writeMask = AttributeWriter.writeMaskForAttribute(attributeId);
            Set<WriteMask> writeMasks = AttributeUtil.getWriteMasks(node, internalContext);
            if (!writeMasks.contains((Object)writeMask)) {
                throw new UaException(2151350272L);
            }
            Set<WriteMask> userWriteMasks = AttributeUtil.getUserWriteMasks(node, context);
            if (!userWriteMasks.contains((Object)writeMask)) {
                throw new UaException(2149515264L);
            }
        }
        Variant updateVariant = value.getValue();
        if (indexRange != null) {
            NumericRange range = NumericRange.parse(indexRange);
            DataValue current = node.getAttribute(internalContext, attributeId);
            Variant currentVariant = current.getValue();
            Object valueAtRange = NumericRange.writeToValueAtRange(currentVariant, updateVariant, range);
            updateVariant = new Variant(valueAtRange);
        }
        DateTime sourceTime = value.getSourceTime();
        DateTime serverTime = value.getServerTime();
        value = new DataValue(updateVariant, value.getStatusCode(), sourceTime == null || sourceTime.isNull() ? DateTime.now() : sourceTime, serverTime == null || serverTime.isNull() ? DateTime.now() : serverTime);
        if (attributeId == AttributeId.Value) {
            Integer valueRank;
            NodeId dataType = (NodeId)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.DataType));
            if (dataType != null) {
                value = AttributeWriter.validateDataType(dataType.expanded(), value);
            }
            if ((valueRank = (Integer)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.ValueRank))) == null) {
                valueRank = 0;
            }
            if (valueRank > 0) {
                UInteger[] arrayDimensions = (UInteger[])AttributeUtil.extract(node.getAttribute(context, AttributeId.ArrayDimensions));
                AttributeWriter.validateArrayType(valueRank, arrayDimensions, value);
            }
            node.setAttribute(context, attributeId, value);
        } else {
            node.setAttribute(context, attributeId, value);
        }
    }

    private static WriteMask writeMaskForAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case AccessLevel: {
                return WriteMask.AccessLevel;
            }
            case ArrayDimensions: {
                return WriteMask.ArrayDimensions;
            }
            case BrowseName: {
                return WriteMask.BrowseName;
            }
            case ContainsNoLoops: {
                return WriteMask.ContainsNoLoops;
            }
            case DataType: {
                return WriteMask.DataType;
            }
            case Description: {
                return WriteMask.Description;
            }
            case DisplayName: {
                return WriteMask.DisplayName;
            }
            case EventNotifier: {
                return WriteMask.EventNotifier;
            }
            case Executable: {
                return WriteMask.Executable;
            }
            case Historizing: {
                return WriteMask.Historizing;
            }
            case InverseName: {
                return WriteMask.InverseName;
            }
            case IsAbstract: {
                return WriteMask.IsAbstract;
            }
            case MinimumSamplingInterval: {
                return WriteMask.MinimumSamplingInterval;
            }
            case NodeClass: {
                return WriteMask.NodeClass;
            }
            case NodeId: {
                return WriteMask.NodeId;
            }
            case Symmetric: {
                return WriteMask.Symmetric;
            }
            case UserAccessLevel: {
                return WriteMask.UserAccessLevel;
            }
            case UserExecutable: {
                return WriteMask.UserExecutable;
            }
            case UserWriteMask: {
                return WriteMask.UserWriteMask;
            }
            case Value: {
                return WriteMask.ValueForVariableType;
            }
            case ValueRank: {
                return WriteMask.ValueRank;
            }
            case WriteMask: {
                return WriteMask.WriteMask;
            }
        }
        throw new IllegalArgumentException("unknown AttributeId: " + (Object)((Object)attributeId));
    }

    static DataValue validateDataType(ExpandedNodeId dataType, DataValue value) throws UaException {
        Class<?> actual;
        Variant variant = value.getValue();
        if (variant == null) {
            return value;
        }
        Object o = variant.getValue();
        if (o == null) {
            throw new UaException(2155085824L);
        }
        Class<?> expected = TypeUtil.getBackingClass(dataType);
        Class<?> clazz = actual = o.getClass().isArray() ? o.getClass().getComponentType() : o.getClass();
        if (expected == null) {
            throw new UaException(2155085824L);
        }
        if (!expected.isAssignableFrom(actual)) {
            if (o instanceof ByteString && expected == UByte.class) {
                ByteString byteString = (ByteString)o;
                return new DataValue(new Variant(byteString.uBytes()), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
            }
            if (expected == Variant.class) {
                return value;
            }
            throw new UaException(2155085824L);
        }
        return value;
    }

    static void validateArrayType(Integer valueRank, UInteger[] arrayDimensions, DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return;
        }
        Object o = variant.getValue();
        if (o == null) {
            return;
        }
        boolean valueIsArray = o.getClass().isArray();
        switch (valueRank) {
            case -3: {
                int[] valueDimensions;
                if (!valueIsArray || (valueDimensions = ArrayUtil.getDimensions(o)).length <= 1) break;
                throw new UaException(2155085824L);
            }
            case -2: {
                break;
            }
            case -1: {
                if (!valueIsArray) break;
                throw new UaException(2155085824L);
            }
            case 0: {
                if (valueIsArray) break;
                throw new UaException(2155085824L);
            }
            default: {
                if (!valueIsArray) {
                    throw new UaException(2155085824L);
                }
                int[] valueDimensions = ArrayUtil.getDimensions(o);
                if (valueDimensions.length != valueRank) {
                    throw new UaException(2155085824L);
                }
                int[] nodeDimensions = Optional.ofNullable(arrayDimensions).map(uia -> {
                    int[] dims = new int[((UInteger[])uia).length];
                    for (int i = 0; i < ((UInteger[])uia).length; ++i) {
                        dims[i] = uia[i].intValue();
                    }
                    return dims;
                }).orElse(new int[0]);
                if (nodeDimensions.length <= 0) break;
                if (nodeDimensions.length != valueDimensions.length) {
                    throw new UaException(2155085824L);
                }
                for (int i = 0; i < nodeDimensions.length; ++i) {
                    if (nodeDimensions[i] <= 0 || valueDimensions[i] <= nodeDimensions[i]) continue;
                    throw new UaException(2155085824L);
                }
            }
        }
    }
}

