/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;

public class AttributeReader {
    public static DataValue readAttribute(AttributeContext context, ServerNode node, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange) {
        try {
            AttributeContext internalContext = new AttributeContext(context.getServer());
            NodeClass nodeClass = node.getNodeClass();
            if (attributeId == AttributeId.Value && nodeClass == NodeClass.Variable) {
                Set<AccessLevel> accessLevels = AttributeUtil.getAccessLevels(node, internalContext);
                if (!accessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2151350272L);
                }
                Set<AccessLevel> userAccessLevels = AttributeUtil.getUserAccessLevels(node, context);
                if (!userAccessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2149515264L);
                }
            }
            DataValue value = node.getAttribute(context, attributeId);
            if (indexRange != null) {
                NumericRange range = NumericRange.parse(indexRange);
                Object valueAtRange = NumericRange.readFromValueAtRange(value.getValue(), range);
                value = new DataValue(new Variant(valueAtRange), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
            }
            if (timestamps != null) {
                value = attributeId == AttributeId.Value ? DataValue.derivedValue(value, timestamps) : DataValue.derivedNonValue(value, timestamps);
            }
            return value;
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }
}

