/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.NamespaceManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.AttributeManager;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class BrowsePathsHelper {
    private final AccessContext context;
    private final OpcUaServer server;
    private final NamespaceManager namespaceManager;

    public BrowsePathsHelper(AccessContext context, OpcUaServer server, NamespaceManager namespaceManager) {
        this.context = context;
        this.server = server;
        this.namespaceManager = namespaceManager;
    }

    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        List<BrowsePath> browsePaths = ConversionUtil.l(service.getRequest().getBrowsePaths());
        if (browsePaths.size() > server.getConfig().getLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue()) {
            service.setServiceFault(0x80100000L);
        } else {
            ArrayList futures = Lists.newArrayListWithCapacity((int)browsePaths.size());
            for (BrowsePath browsePath : browsePaths) {
                futures.add(this.translate(browsePath));
            }
            FutureUtils.sequence(futures).thenAcceptAsync(results -> {
                ResponseHeader header = service.createResponseHeader();
                TranslateBrowsePathsToNodeIdsResponse response = new TranslateBrowsePathsToNodeIdsResponse(header, ConversionUtil.a(results, BrowsePathResult.class), new DiagnosticInfo[0]);
                service.setResponse(response);
            }, (Executor)server.getExecutorService());
        }
    }

    private CompletableFuture<BrowsePathResult> translate(BrowsePath browsePath) {
        CompletableFuture<BrowsePathResult> future = new CompletableFuture<BrowsePathResult>();
        NodeId startingNode = browsePath.getStartingNode();
        RelativePath relativePath = browsePath.getRelativePath();
        this.follow(startingNode, ConversionUtil.l(relativePath.getElements())).whenComplete((targets, ex) -> {
            if (targets != null) {
                BrowsePathResult result = !targets.isEmpty() ? new BrowsePathResult(StatusCode.GOOD, ConversionUtil.a(targets, BrowsePathTarget.class)) : new BrowsePathResult(new StatusCode(2154758144L), new BrowsePathTarget[0]);
                future.complete(result);
            } else {
                StatusCode statusCode = new StatusCode(2154758144L);
                if (ex instanceof UaException) {
                    statusCode = ((UaException)ex).getStatusCode();
                }
                BrowsePathResult result = new BrowsePathResult(statusCode, new BrowsePathTarget[0]);
                future.complete(result);
            }
        });
        return future;
    }

    private CompletableFuture<List<BrowsePathTarget>> follow(NodeId nodeId, List<RelativePathElement> elements) {
        if (elements.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (elements.size() == 1) {
            return this.target(nodeId, elements.get(0)).thenApply(targets -> targets.stream().map(n -> new BrowsePathTarget((ExpandedNodeId)n, UInteger.MAX)).collect(Collectors.toList()));
        }
        RelativePathElement e = elements.get(0);
        return this.next(nodeId, e).thenCompose(nextExId -> {
            List<RelativePathElement> nextElements = elements.subList(1, elements.size());
            Optional<NodeId> nextId = this.namespaceManager.toNodeId((ExpandedNodeId)nextExId);
            if (nextId.isPresent()) {
                return this.follow(nextId.get(), nextElements);
            }
            UInteger remaining = nextElements.isEmpty() ? UInteger.MAX : Unsigned.uint(nextElements.size());
            ArrayList targets = Lists.newArrayList((Object[])new BrowsePathTarget[]{new BrowsePathTarget((ExpandedNodeId)nextExId, remaining)});
            return CompletableFuture.completedFuture(targets);
        });
    }

    private CompletableFuture<ExpandedNodeId> next(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
        CompletableFuture<List<Reference>> future = namespace.browse(this.context, nodeId);
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals(referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!browseName.equals(targetName)) continue;
                    return targetNodeId;
                }
                return ExpandedNodeId.NULL_VALUE;
            });
        });
    }

    private CompletableFuture<List<ExpandedNodeId>> target(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
        CompletableFuture<List<Reference>> future = namespace.browse(this.context, nodeId);
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals(referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                ArrayList targets = Lists.newArrayList();
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!this.matchesTarget(browseName, targetName)) continue;
                    targets.add(targetNodeId);
                }
                return targets;
            });
        });
    }

    private CompletableFuture<List<QualifiedName>> readTargetBrowseNames(List<ExpandedNodeId> targetNodeIds) {
        ArrayList futures = Lists.newArrayListWithCapacity((int)targetNodeIds.size());
        for (ExpandedNodeId xni : targetNodeIds) {
            CompletableFuture<ArrayList> future = xni.local().map(nodeId -> {
                Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
                ReadValueId readValueId = new ReadValueId((NodeId)nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE);
                CompletableFuture<List<DataValue>> readFuture = new CompletableFuture<List<DataValue>>();
                AttributeManager.ReadContext context = new AttributeManager.ReadContext(this.server, null, readFuture, new DiagnosticsContext<ReadValueId>());
                namespace.read(context, 0.0, TimestampsToReturn.Neither, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
                return readFuture;
            }).orElse(CompletableFuture.completedFuture(Lists.newArrayList((Object[])new DataValue[]{new DataValue(2150891520L)})));
            futures.add(future);
        }
        return FutureUtils.sequence(futures).thenApply(values -> values.stream().map(l -> {
            DataValue v = (DataValue)l.get(0);
            return (QualifiedName)v.getValue().getValue();
        }).collect(Collectors.toList()));
    }

    private boolean matchesTarget(QualifiedName browseName, QualifiedName targetName) {
        return targetName == null || targetName.equals(QualifiedName.NULL_VALUE) || targetName.equals(browseName);
    }
}

