/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.NamespaceManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.api.ViewManager;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceMetric;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowsePathsHelper;
import org.eclipse.milo.opcua.sdk.server.util.PendingBrowse;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class ViewServices
implements ViewServiceSet {
    private final ServiceMetric browseCounter = new ServiceMetric();
    private final ServiceMetric browseNextCounter = new ServiceMetric();
    private final ServiceMetric translateBrowsePathsCounter = new ServiceMetric();
    private final BrowseHelper browseHelper = new BrowseHelper();

    @Override
    public void onBrowse(ServiceRequest<BrowseRequest, BrowseResponse> service) {
        this.browseCounter.record(service);
        BrowseRequest request = service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List<BrowseDescription> nodesToBrowse = ConversionUtil.l(request.getNodesToBrowse());
        if (nodesToBrowse.size() > server.getConfig().getLimits().getMaxNodesPerBrowse().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        ArrayList pendingBrowses = Lists.newArrayListWithCapacity((int)nodesToBrowse.size());
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToBrowse.size());
        for (BrowseDescription browseDescription : nodesToBrowse) {
            PendingBrowse pending2 = new PendingBrowse(browseDescription);
            pendingBrowses.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingBrowse>> byNamespace = pendingBrowses.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<BrowseResult>> future = new CompletableFuture<List<BrowseResult>>();
            ViewManager.BrowseContext context = new ViewManager.BrowseContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<BrowseDescription> browseDescriptions = pending.stream().map(PendingBrowse::getInput).collect(Collectors.toList());
                namespace.browse(context, request.getView(), request.getRequestedMaxReferencesPerNode(), browseDescriptions);
            });
            future.thenAccept(results -> {
                for (int i = 0; i < results.size(); ++i) {
                    ((PendingBrowse)pending.get(i)).getFuture().complete((BrowseResult)results.get(i));
                }
            });
        });
        FutureUtils.sequence(futures).thenAcceptAsync(results -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToBrowse);
            BrowseResponse response = new BrowseResponse(header, ConversionUtil.a(results, BrowseResult.class), diagnosticInfos);
            service.setResponse(response);
        }, (Executor)server.getExecutorService());
    }

    @Override
    public void onBrowseNext(ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) {
        this.browseNextCounter.record(service);
        this.browseHelper.browseNext(service);
    }

    @Override
    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) {
        this.translateBrowsePathsCounter.record(service);
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        NamespaceManager namespaceManager = server.getNamespaceManager();
        BrowsePathsHelper browsePathsHelper = new BrowsePathsHelper(() -> Optional.ofNullable(session), server, namespaceManager);
        browsePathsHelper.onTranslateBrowsePaths(service);
    }

    @Override
    public void onRegisterNodes(ServiceRequest<RegisterNodesRequest, RegisterNodesResponse> service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        RegisterNodesRequest request = service.getRequest();
        List<NodeId> nodeIds = ConversionUtil.l(request.getNodesToRegister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        service.setResponse(new RegisterNodesResponse(service.createResponseHeader(StatusCode.GOOD), ConversionUtil.a(nodeIds, NodeId.class)));
    }

    @Override
    public void onUnregisterNodes(ServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        UnregisterNodesRequest request = service.getRequest();
        List<NodeId> nodeIds = ConversionUtil.l(request.getNodesToUnregister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        service.setResponse(new UnregisterNodesResponse(service.createResponseHeader(StatusCode.GOOD)));
    }
}

