/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;

public class ServiceMetric {
    private final Timer requestTimer = new Timer();
    private final Counter errorCounter = new Counter();

    public void record(ServiceRequest<?, ?> service) {
        Timer.Context context = this.requestTimer.time();
        service.getFuture().whenComplete((r, ex) -> {
            context.stop();
            if (ex != null) {
                this.errorCounter.inc();
            }
        });
    }

    public Timer getRequestTimer() {
        return this.requestTimer;
    }

    public Counter getErrorCounter() {
        return this.errorCounter;
    }

    public ServiceCounterDataType getServiceCounter() {
        return new ServiceCounterDataType(Unsigned.uint(this.requestTimer.getCount()), Unsigned.uint(this.errorCounter.getCount()));
    }
}

