/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.MethodServices;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceMetric;
import org.eclipse.milo.opcua.sdk.server.util.PendingCall;
import org.eclipse.milo.opcua.stack.core.application.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class MethodServices
implements MethodServiceSet {
    private final ServiceMetric callCounter = new ServiceMetric();

    @Override
    public void onCall(ServiceRequest<CallRequest, CallResponse> service) {
        this.callCounter.record(service);
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        CallRequest request = service.getRequest();
        List pendingCalls = ConversionUtil.l(request.getMethodsToCall()).stream().map(PendingCall::new).collect(Collectors.toList());
        Map<UShort, List<PendingCall>> byNamespace = pendingCalls.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getMethodId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            List requests = pending.stream().map(PendingCall::getInput).collect(Collectors.toList());
            Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
            CompletableFuture<List<CallMethodResult>> future = new CompletableFuture<List<CallMethodResult>>();
            MethodServices.CallContext context = new MethodServices.CallContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> namespace.call(context, requests));
            future.thenAccept(values -> {
                for (int i = 0; i < values.size(); ++i) {
                    ((PendingCall)pending.get(i)).getFuture().complete((CallMethodResult)values.get(i));
                }
            });
        });
        List futures = pendingCalls.stream().map(PendingCall::getFuture).collect(Collectors.toList());
        FutureUtils.sequence(futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            CallResponse response = new CallResponse(header, ConversionUtil.a(values, CallMethodResult.class), new DiagnosticInfo[0]);
            service.setResponse(response);
        }, (Executor)server.getExecutorService());
    }
}

