/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public interface GetSetVariableTypeNode
extends GetSetBase {
    default public DataValue getVariableTypeAttribute(AttributeContext context, VariableTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Value: {
                return this.getValue(context, node);
            }
            case DataType: {
                return AttributeUtil.dv(this.getDataType(context, node));
            }
            case ValueRank: {
                return AttributeUtil.dv(this.getValueRank(context, node));
            }
            case ArrayDimensions: {
                return AttributeUtil.dv(this.getArrayDimensions(context, node));
            }
            case IsAbstract: {
                return AttributeUtil.dv(this.getIsAbstract(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setVariableTypeAttribute(AttributeContext context, VariableTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case Value: {
                this.setValue(context, node, value);
                break;
            }
            case DataType: {
                this.setDataType(context, node, (NodeId)AttributeUtil.extract(value));
                break;
            }
            case ValueRank: {
                this.setValueRank(context, node, (Integer)AttributeUtil.extract(value));
                break;
            }
            case ArrayDimensions: {
                this.setArrayDimensions(context, node, (UInteger[])AttributeUtil.extract(value));
                break;
            }
            case IsAbstract: {
                this.setIsAbstract(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public DataValue getValue(AttributeContext context, VariableTypeNode node) throws UaException {
        return node.getValue();
    }

    default public NodeId getDataType(AttributeContext context, VariableTypeNode node) throws UaException {
        return node.getDataType();
    }

    default public Integer getValueRank(AttributeContext context, VariableTypeNode node) throws UaException {
        return node.getValueRank();
    }

    default public UInteger[] getArrayDimensions(AttributeContext context, VariableTypeNode node) throws UaException {
        return node.getArrayDimensions();
    }

    default public Boolean getIsAbstract(AttributeContext context, VariableTypeNode node) throws UaException {
        return node.getIsAbstract();
    }

    default public void setValue(AttributeContext context, VariableTypeNode node, DataValue value) throws UaException {
        node.setValue(value);
    }

    default public void setDataType(AttributeContext context, VariableTypeNode node, NodeId dataType) throws UaException {
        node.setDataType(dataType);
    }

    default public void setValueRank(AttributeContext context, VariableTypeNode node, Integer valueRank) throws UaException {
        node.setValueRank(valueRank);
    }

    default public void setArrayDimensions(AttributeContext context, VariableTypeNode node, UInteger[] arrayDimensions) throws UaException {
        node.setArrayDimensions(arrayDimensions);
    }

    default public void setIsAbstract(AttributeContext context, VariableTypeNode node, Boolean isAbstract) throws UaException {
        node.setIsAbstract(isAbstract);
    }
}

