/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.model.BasicProperty;
import org.eclipse.milo.opcua.sdk.core.model.Property;
import org.eclipse.milo.opcua.sdk.core.model.UaOptional;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaReferenceTypeNode
extends UaNode
implements ReferenceTypeNode {
    private volatile Boolean isAbstract;
    private volatile Boolean symmetric;
    private volatile LocalizedText inverseName;
    public static final Property<String> NodeVersion = new BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);

    public UaReferenceTypeNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract, Boolean symmetric, LocalizedText inverseName) {
        super(nodeMap, nodeId, NodeClass.ReferenceType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public Boolean getSymmetric() {
        return this.symmetric;
    }

    @Override
    public LocalizedText getInverseName() {
        return this.inverseName;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(AttributeId.IsAbstract, isAbstract);
    }

    @Override
    public synchronized void setSymmetric(Boolean symmetric) {
        this.symmetric = symmetric;
        this.fireAttributeChanged(AttributeId.Symmetric, symmetric);
    }

    @Override
    public synchronized void setInverseName(LocalizedText inverseName) {
        this.inverseName = inverseName;
        this.fireAttributeChanged(AttributeId.InverseName, inverseName);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }
}

