/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.DiscreteItemNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.TwoStateDiscreteType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaVariableNode(typeName="0:TwoStateDiscreteType")
public class TwoStateDiscreteNode
extends DiscreteItemNode
implements TwoStateDiscreteType {
    public TwoStateDiscreteNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public TwoStateDiscreteNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public LocalizedText getFalseState() {
        Optional<LocalizedText> property = this.getProperty(TwoStateDiscreteType.FALSE_STATE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getFalseStateNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(TwoStateDiscreteType.FALSE_STATE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setFalseState(LocalizedText value) {
        this.setProperty(TwoStateDiscreteType.FALSE_STATE, value);
    }

    @Override
    public LocalizedText getTrueState() {
        Optional<LocalizedText> property = this.getProperty(TwoStateDiscreteType.TRUE_STATE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getTrueStateNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(TwoStateDiscreteType.TRUE_STATE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setTrueState(LocalizedText value) {
        this.setProperty(TwoStateDiscreteType.TRUE_STATE, value);
    }
}

