/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.SessionDiagnosticsVariableType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionDiagnosticsDataType;

@UaVariableNode(typeName="0:SessionDiagnosticsVariableType")
public class SessionDiagnosticsVariableNode
extends BaseDataVariableNode
implements SessionDiagnosticsVariableType {
    public SessionDiagnosticsVariableNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public SessionDiagnosticsVariableNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public synchronized DataValue getValue() {
        SessionDiagnosticsDataType value = new SessionDiagnosticsDataType(this.getSessionId(), this.getSessionName(), this.getClientDescription(), this.getServerUri(), this.getEndpointUrl(), this.getLocaleIds(), this.getActualSessionTimeout(), this.getMaxResponseMessageSize(), this.getClientConnectionTime(), this.getClientLastContactTime(), this.getCurrentSubscriptionsCount(), this.getCurrentMonitoredItemsCount(), this.getCurrentPublishRequestsInQueue(), this.getTotalRequestCount(), this.getUnauthorizedRequestCount(), this.getReadCount(), this.getHistoryReadCount(), this.getWriteCount(), this.getHistoryUpdateCount(), this.getCallCount(), this.getCreateMonitoredItemsCount(), this.getModifyMonitoredItemsCount(), this.getSetMonitoringModeCount(), this.getSetTriggeringCount(), this.getDeleteMonitoredItemsCount(), this.getCreateSubscriptionCount(), this.getModifySubscriptionCount(), this.getSetPublishingModeCount(), this.getPublishCount(), this.getRepublishCount(), this.getTransferSubscriptionsCount(), this.getDeleteSubscriptionsCount(), this.getAddNodesCount(), this.getAddReferencesCount(), this.getDeleteNodesCount(), this.getDeleteReferencesCount(), this.getBrowseCount(), this.getBrowseNextCount(), this.getTranslateBrowsePathsToNodeIdsCount(), this.getQueryFirstCount(), this.getQueryNextCount(), this.getRegisterNodesCount(), this.getUnregisterNodesCount());
        return new DataValue(new Variant(value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        super.setValue(value);
        Object o = value.getValue().getValue();
        if (o instanceof SessionDiagnosticsDataType) {
            SessionDiagnosticsDataType v = (SessionDiagnosticsDataType)o;
            this.setSessionId(v.getSessionId());
            this.setSessionName(v.getSessionName());
            this.setClientDescription(v.getClientDescription());
            this.setServerUri(v.getServerUri());
            this.setEndpointUrl(v.getEndpointUrl());
            this.setLocaleIds(v.getLocaleIds());
            this.setActualSessionTimeout(v.getActualSessionTimeout());
            this.setMaxResponseMessageSize(v.getMaxResponseMessageSize());
            this.setClientConnectionTime(v.getClientConnectionTime());
            this.setClientLastContactTime(v.getClientLastContactTime());
            this.setCurrentSubscriptionsCount(v.getCurrentSubscriptionsCount());
            this.setCurrentMonitoredItemsCount(v.getCurrentMonitoredItemsCount());
            this.setCurrentPublishRequestsInQueue(v.getCurrentPublishRequestsInQueue());
            this.setTotalRequestCount(v.getTotalRequestCount());
            this.setUnauthorizedRequestCount(v.getUnauthorizedRequestCount());
            this.setReadCount(v.getReadCount());
            this.setHistoryReadCount(v.getHistoryReadCount());
            this.setWriteCount(v.getWriteCount());
            this.setHistoryUpdateCount(v.getHistoryUpdateCount());
            this.setCallCount(v.getCallCount());
            this.setCreateMonitoredItemsCount(v.getCreateMonitoredItemsCount());
            this.setModifyMonitoredItemsCount(v.getModifyMonitoredItemsCount());
            this.setSetMonitoringModeCount(v.getSetMonitoringModeCount());
            this.setSetTriggeringCount(v.getSetTriggeringCount());
            this.setDeleteMonitoredItemsCount(v.getDeleteMonitoredItemsCount());
            this.setCreateSubscriptionCount(v.getCreateSubscriptionCount());
            this.setModifySubscriptionCount(v.getModifySubscriptionCount());
            this.setSetPublishingModeCount(v.getSetPublishingModeCount());
            this.setPublishCount(v.getPublishCount());
            this.setRepublishCount(v.getRepublishCount());
            this.setTransferSubscriptionsCount(v.getTransferSubscriptionsCount());
            this.setDeleteSubscriptionsCount(v.getDeleteSubscriptionsCount());
            this.setAddNodesCount(v.getAddNodesCount());
            this.setAddReferencesCount(v.getAddReferencesCount());
            this.setDeleteNodesCount(v.getDeleteNodesCount());
            this.setDeleteReferencesCount(v.getDeleteReferencesCount());
            this.setBrowseCount(v.getBrowseCount());
            this.setBrowseNextCount(v.getBrowseNextCount());
            this.setTranslateBrowsePathsToNodeIdsCount(v.getTranslateBrowsePathsToNodeIdsCount());
            this.setQueryFirstCount(v.getQueryFirstCount());
            this.setQueryNextCount(v.getQueryNextCount());
            this.setRegisterNodesCount(v.getRegisterNodesCount());
            this.setUnregisterNodesCount(v.getUnregisterNodesCount());
        }
    }

    @Override
    public NodeId getSessionId() {
        Optional<VariableNode> component = this.getVariableComponent("SessionId");
        return component.map(node -> (NodeId)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSessionIdNode() {
        Optional<VariableNode> component = this.getVariableComponent("SessionId");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSessionId(NodeId value) {
        this.getVariableComponent("SessionId").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public String getSessionName() {
        Optional<VariableNode> component = this.getVariableComponent("SessionName");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSessionNameNode() {
        Optional<VariableNode> component = this.getVariableComponent("SessionName");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSessionName(String value) {
        this.getVariableComponent("SessionName").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ApplicationDescription getClientDescription() {
        Optional<VariableNode> component = this.getVariableComponent("ClientDescription");
        return component.map(node -> (ApplicationDescription)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getClientDescriptionNode() {
        Optional<VariableNode> component = this.getVariableComponent("ClientDescription");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setClientDescription(ApplicationDescription value) {
        this.getVariableComponent("ClientDescription").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public String getServerUri() {
        Optional<VariableNode> component = this.getVariableComponent("ServerUri");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getServerUriNode() {
        Optional<VariableNode> component = this.getVariableComponent("ServerUri");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setServerUri(String value) {
        this.getVariableComponent("ServerUri").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public String getEndpointUrl() {
        Optional<VariableNode> component = this.getVariableComponent("EndpointUrl");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getEndpointUrlNode() {
        Optional<VariableNode> component = this.getVariableComponent("EndpointUrl");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setEndpointUrl(String value) {
        this.getVariableComponent("EndpointUrl").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public String[] getLocaleIds() {
        Optional<VariableNode> component = this.getVariableComponent("LocaleIds");
        return component.map(node -> (String[])node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getLocaleIdsNode() {
        Optional<VariableNode> component = this.getVariableComponent("LocaleIds");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setLocaleIds(String[] value) {
        this.getVariableComponent("LocaleIds").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public Double getActualSessionTimeout() {
        Optional<VariableNode> component = this.getVariableComponent("ActualSessionTimeout");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getActualSessionTimeoutNode() {
        Optional<VariableNode> component = this.getVariableComponent("ActualSessionTimeout");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setActualSessionTimeout(Double value) {
        this.getVariableComponent("ActualSessionTimeout").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getMaxResponseMessageSize() {
        Optional<VariableNode> component = this.getVariableComponent("MaxResponseMessageSize");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getMaxResponseMessageSizeNode() {
        Optional<VariableNode> component = this.getVariableComponent("MaxResponseMessageSize");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setMaxResponseMessageSize(UInteger value) {
        this.getVariableComponent("MaxResponseMessageSize").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public DateTime getClientConnectionTime() {
        Optional<VariableNode> component = this.getVariableComponent("ClientConnectionTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getClientConnectionTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("ClientConnectionTime");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setClientConnectionTime(DateTime value) {
        this.getVariableComponent("ClientConnectionTime").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public DateTime getClientLastContactTime() {
        Optional<VariableNode> component = this.getVariableComponent("ClientLastContactTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getClientLastContactTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("ClientLastContactTime");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setClientLastContactTime(DateTime value) {
        this.getVariableComponent("ClientLastContactTime").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getCurrentSubscriptionsCount() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSubscriptionsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentSubscriptionsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSubscriptionsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentSubscriptionsCount(UInteger value) {
        this.getVariableComponent("CurrentSubscriptionsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getCurrentMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentMonitoredItemsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentMonitoredItemsCount(UInteger value) {
        this.getVariableComponent("CurrentMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getCurrentPublishRequestsInQueue() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentPublishRequestsInQueue");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentPublishRequestsInQueueNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentPublishRequestsInQueue");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentPublishRequestsInQueue(UInteger value) {
        this.getVariableComponent("CurrentPublishRequestsInQueue").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getTotalRequestCount() {
        Optional<VariableNode> component = this.getVariableComponent("TotalRequestCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getTotalRequestCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("TotalRequestCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setTotalRequestCount(ServiceCounterDataType value) {
        this.getVariableComponent("TotalRequestCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getUnauthorizedRequestCount() {
        Optional<VariableNode> component = this.getVariableComponent("UnauthorizedRequestCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getUnauthorizedRequestCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("UnauthorizedRequestCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setUnauthorizedRequestCount(UInteger value) {
        this.getVariableComponent("UnauthorizedRequestCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getReadCount() {
        Optional<VariableNode> component = this.getVariableComponent("ReadCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getReadCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("ReadCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setReadCount(ServiceCounterDataType value) {
        this.getVariableComponent("ReadCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getHistoryReadCount() {
        Optional<VariableNode> component = this.getVariableComponent("HistoryReadCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getHistoryReadCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("HistoryReadCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setHistoryReadCount(ServiceCounterDataType value) {
        this.getVariableComponent("HistoryReadCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getWriteCount() {
        Optional<VariableNode> component = this.getVariableComponent("WriteCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getWriteCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("WriteCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setWriteCount(ServiceCounterDataType value) {
        this.getVariableComponent("WriteCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getHistoryUpdateCount() {
        Optional<VariableNode> component = this.getVariableComponent("HistoryUpdateCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getHistoryUpdateCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("HistoryUpdateCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setHistoryUpdateCount(ServiceCounterDataType value) {
        this.getVariableComponent("HistoryUpdateCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getCallCount() {
        Optional<VariableNode> component = this.getVariableComponent("CallCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCallCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CallCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCallCount(ServiceCounterDataType value) {
        this.getVariableComponent("CallCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("CreateMonitoredItemsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCreateMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CreateMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCreateMonitoredItemsCount(ServiceCounterDataType value) {
        this.getVariableComponent("CreateMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("ModifyMonitoredItemsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getModifyMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("ModifyMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setModifyMonitoredItemsCount(ServiceCounterDataType value) {
        this.getVariableComponent("ModifyMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getSetMonitoringModeCount() {
        Optional<VariableNode> component = this.getVariableComponent("SetMonitoringModeCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSetMonitoringModeCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SetMonitoringModeCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSetMonitoringModeCount(ServiceCounterDataType value) {
        this.getVariableComponent("SetMonitoringModeCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getSetTriggeringCount() {
        Optional<VariableNode> component = this.getVariableComponent("SetTriggeringCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSetTriggeringCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SetTriggeringCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSetTriggeringCount(ServiceCounterDataType value) {
        this.getVariableComponent("SetTriggeringCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteMonitoredItemsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getDeleteMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setDeleteMonitoredItemsCount(ServiceCounterDataType value) {
        this.getVariableComponent("DeleteMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getCreateSubscriptionCount() {
        Optional<VariableNode> component = this.getVariableComponent("CreateSubscriptionCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCreateSubscriptionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CreateSubscriptionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCreateSubscriptionCount(ServiceCounterDataType value) {
        this.getVariableComponent("CreateSubscriptionCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getModifySubscriptionCount() {
        Optional<VariableNode> component = this.getVariableComponent("ModifySubscriptionCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getModifySubscriptionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("ModifySubscriptionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setModifySubscriptionCount(ServiceCounterDataType value) {
        this.getVariableComponent("ModifySubscriptionCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getSetPublishingModeCount() {
        Optional<VariableNode> component = this.getVariableComponent("SetPublishingModeCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSetPublishingModeCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SetPublishingModeCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSetPublishingModeCount(ServiceCounterDataType value) {
        this.getVariableComponent("SetPublishingModeCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getPublishCount() {
        Optional<VariableNode> component = this.getVariableComponent("PublishCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getPublishCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("PublishCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setPublishCount(ServiceCounterDataType value) {
        this.getVariableComponent("PublishCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getRepublishCount() {
        Optional<VariableNode> component = this.getVariableComponent("RepublishCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getRepublishCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("RepublishCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setRepublishCount(ServiceCounterDataType value) {
        this.getVariableComponent("RepublishCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getTransferSubscriptionsCount() {
        Optional<VariableNode> component = this.getVariableComponent("TransferSubscriptionsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getTransferSubscriptionsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("TransferSubscriptionsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setTransferSubscriptionsCount(ServiceCounterDataType value) {
        this.getVariableComponent("TransferSubscriptionsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteSubscriptionsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getDeleteSubscriptionsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteSubscriptionsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setDeleteSubscriptionsCount(ServiceCounterDataType value) {
        this.getVariableComponent("DeleteSubscriptionsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getAddNodesCount() {
        Optional<VariableNode> component = this.getVariableComponent("AddNodesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getAddNodesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("AddNodesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setAddNodesCount(ServiceCounterDataType value) {
        this.getVariableComponent("AddNodesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getAddReferencesCount() {
        Optional<VariableNode> component = this.getVariableComponent("AddReferencesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getAddReferencesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("AddReferencesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setAddReferencesCount(ServiceCounterDataType value) {
        this.getVariableComponent("AddReferencesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getDeleteNodesCount() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteNodesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getDeleteNodesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteNodesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setDeleteNodesCount(ServiceCounterDataType value) {
        this.getVariableComponent("DeleteNodesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getDeleteReferencesCount() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteReferencesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getDeleteReferencesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("DeleteReferencesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setDeleteReferencesCount(ServiceCounterDataType value) {
        this.getVariableComponent("DeleteReferencesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getBrowseCount() {
        Optional<VariableNode> component = this.getVariableComponent("BrowseCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getBrowseCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("BrowseCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setBrowseCount(ServiceCounterDataType value) {
        this.getVariableComponent("BrowseCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getBrowseNextCount() {
        Optional<VariableNode> component = this.getVariableComponent("BrowseNextCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getBrowseNextCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("BrowseNextCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setBrowseNextCount(ServiceCounterDataType value) {
        this.getVariableComponent("BrowseNextCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        Optional<VariableNode> component = this.getVariableComponent("TranslateBrowsePathsToNodeIdsCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getTranslateBrowsePathsToNodeIdsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("TranslateBrowsePathsToNodeIdsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType value) {
        this.getVariableComponent("TranslateBrowsePathsToNodeIdsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getQueryFirstCount() {
        Optional<VariableNode> component = this.getVariableComponent("QueryFirstCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getQueryFirstCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("QueryFirstCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setQueryFirstCount(ServiceCounterDataType value) {
        this.getVariableComponent("QueryFirstCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getQueryNextCount() {
        Optional<VariableNode> component = this.getVariableComponent("QueryNextCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getQueryNextCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("QueryNextCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setQueryNextCount(ServiceCounterDataType value) {
        this.getVariableComponent("QueryNextCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getRegisterNodesCount() {
        Optional<VariableNode> component = this.getVariableComponent("RegisterNodesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getRegisterNodesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("RegisterNodesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setRegisterNodesCount(ServiceCounterDataType value) {
        this.getVariableComponent("RegisterNodesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServiceCounterDataType getUnregisterNodesCount() {
        Optional<VariableNode> component = this.getVariableComponent("UnregisterNodesCount");
        return component.map(node -> (ServiceCounterDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getUnregisterNodesCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("UnregisterNodesCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setUnregisterNodesCount(ServiceCounterDataType value) {
        this.getVariableComponent("UnregisterNodesCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

