/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ArrayItemNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.CubeItemType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AxisInformation;

@UaVariableNode(typeName="0:CubeItemType")
public class CubeItemNode
extends ArrayItemNode
implements CubeItemType {
    public CubeItemNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public CubeItemNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public AxisInformation getXAxisDefinition() {
        Optional<AxisInformation> property = this.getProperty(CubeItemType.X_AXIS_DEFINITION);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getXAxisDefinitionNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CubeItemType.X_AXIS_DEFINITION.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setXAxisDefinition(AxisInformation value) {
        this.setProperty(CubeItemType.X_AXIS_DEFINITION, value);
    }

    @Override
    public AxisInformation getYAxisDefinition() {
        Optional<AxisInformation> property = this.getProperty(CubeItemType.Y_AXIS_DEFINITION);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getYAxisDefinitionNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CubeItemType.Y_AXIS_DEFINITION.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setYAxisDefinition(AxisInformation value) {
        this.setProperty(CubeItemType.Y_AXIS_DEFINITION, value);
    }

    @Override
    public AxisInformation getZAxisDefinition() {
        Optional<AxisInformation> property = this.getProperty(CubeItemType.Z_AXIS_DEFINITION);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getZAxisDefinitionNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CubeItemType.Z_AXIS_DEFINITION.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setZAxisDefinition(AxisInformation value) {
        this.setProperty(CubeItemType.Z_AXIS_DEFINITION, value);
    }
}

