/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.DataItemNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.AnalogItemType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

@UaVariableNode(typeName="0:AnalogItemType")
public class AnalogItemNode
extends DataItemNode
implements AnalogItemType {
    public AnalogItemNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public AnalogItemNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public Range getInstrumentRange() {
        Optional<Range> property = this.getProperty(AnalogItemType.INSTRUMENT_RANGE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getInstrumentRangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AnalogItemType.INSTRUMENT_RANGE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setInstrumentRange(Range value) {
        this.setProperty(AnalogItemType.INSTRUMENT_RANGE, value);
    }

    @Override
    public Range getEURange() {
        Optional<Range> property = this.getProperty(AnalogItemType.E_U_RANGE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getEURangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AnalogItemType.E_U_RANGE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setEURange(Range value) {
        this.setProperty(AnalogItemType.E_U_RANGE, value);
    }

    @Override
    public EUInformation getEngineeringUnits() {
        Optional<EUInformation> property = this.getProperty(AnalogItemType.ENGINEERING_UNITS);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getEngineeringUnitsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AnalogItemType.ENGINEERING_UNITS.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setEngineeringUnits(EUInformation value) {
        this.setProperty(AnalogItemType.ENGINEERING_UNITS, value);
    }
}

