/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerRedundancyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.TransparentRedundancyType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RedundantServerDataType;

@UaObjectNode(typeName="0:TransparentRedundancyType")
public class TransparentRedundancyNode
extends ServerRedundancyNode
implements TransparentRedundancyType {
    public TransparentRedundancyNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String getCurrentServerId() {
        Optional<String> property = this.getProperty(TransparentRedundancyType.CURRENT_SERVER_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getCurrentServerIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(TransparentRedundancyType.CURRENT_SERVER_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setCurrentServerId(String value) {
        this.setProperty(TransparentRedundancyType.CURRENT_SERVER_ID, value);
    }

    @Override
    public RedundantServerDataType[] getRedundantServerArray() {
        Optional<RedundantServerDataType[]> property = this.getProperty(TransparentRedundancyType.REDUNDANT_SERVER_ARRAY);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getRedundantServerArrayNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(TransparentRedundancyType.REDUNDANT_SERVER_ARRAY.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setRedundantServerArray(RedundantServerDataType[] value) {
        this.setProperty(TransparentRedundancyType.REDUNDANT_SERVER_ARRAY, value);
    }
}

