/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ShelvedStateMachineType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:ShelvedStateMachineType")
public class ShelvedStateMachineNode
extends FiniteStateMachineNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Double getUnshelveTime() {
        Optional<Double> property = this.getProperty(ShelvedStateMachineType.UNSHELVE_TIME);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getUnshelveTimeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ShelvedStateMachineType.UNSHELVE_TIME.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setUnshelveTime(Double value) {
        this.setProperty(ShelvedStateMachineType.UNSHELVE_TIME, value);
    }

    @Override
    public StateNode getUnshelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("Unshelved");
        return component.map(node -> (StateNode)node).orElse(null);
    }

    @Override
    public StateNode getTimedShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("TimedShelved");
        return component.map(node -> (StateNode)node).orElse(null);
    }

    @Override
    public StateNode getOneShotShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("OneShotShelved");
        return component.map(node -> (StateNode)node).orElse(null);
    }

    @Override
    public TransitionNode getUnshelvedToTimedShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("UnshelvedToTimedShelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }

    @Override
    public TransitionNode getUnshelvedToOneShotShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("UnshelvedToOneShotShelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }

    @Override
    public TransitionNode getTimedShelvedToUnshelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("TimedShelvedToUnshelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }

    @Override
    public TransitionNode getTimedShelvedToOneShotShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("TimedShelvedToOneShotShelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }

    @Override
    public TransitionNode getOneShotShelvedToUnshelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("OneShotShelvedToUnshelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }

    @Override
    public TransitionNode getOneShotShelvedToTimedShelvedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("OneShotShelvedToTimedShelved");
        return component.map(node -> (TransitionNode)node).orElse(null);
    }
}

