/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.NamespacesNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerCapabilitiesNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerDiagnosticsNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerRedundancyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.VendorServerInfoNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerStatusNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ServerType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;

@UaObjectNode(typeName="0:ServerType")
public class ServerNode
extends BaseObjectNode
implements ServerType {
    public ServerNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerArray() {
        Optional<String[]> property = this.getProperty(ServerType.SERVER_ARRAY);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getServerArrayNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerType.SERVER_ARRAY.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setServerArray(String[] value) {
        this.setProperty(ServerType.SERVER_ARRAY, value);
    }

    @Override
    public String[] getNamespaceArray() {
        Optional<String[]> property = this.getProperty(ServerType.NAMESPACE_ARRAY);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getNamespaceArrayNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerType.NAMESPACE_ARRAY.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setNamespaceArray(String[] value) {
        this.setProperty(ServerType.NAMESPACE_ARRAY, value);
    }

    @Override
    public UByte getServiceLevel() {
        Optional<UByte> property = this.getProperty(ServerType.SERVICE_LEVEL);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getServiceLevelNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerType.SERVICE_LEVEL.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setServiceLevel(UByte value) {
        this.setProperty(ServerType.SERVICE_LEVEL, value);
    }

    @Override
    public Boolean getAuditing() {
        Optional<Boolean> property = this.getProperty(ServerType.AUDITING);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getAuditingNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerType.AUDITING.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setAuditing(Boolean value) {
        this.setProperty(ServerType.AUDITING, value);
    }

    @Override
    public DateTime getEstimatedReturnTime() {
        Optional<DateTime> property = this.getProperty(ServerType.ESTIMATED_RETURN_TIME);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getEstimatedReturnTimeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerType.ESTIMATED_RETURN_TIME.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setEstimatedReturnTime(DateTime value) {
        this.setProperty(ServerType.ESTIMATED_RETURN_TIME, value);
    }

    @Override
    public ServerCapabilitiesNode getServerCapabilitiesNode() {
        Optional<ObjectNode> component = this.getObjectComponent("ServerCapabilities");
        return component.map(node -> (ServerCapabilitiesNode)node).orElse(null);
    }

    @Override
    public ServerDiagnosticsNode getServerDiagnosticsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("ServerDiagnostics");
        return component.map(node -> (ServerDiagnosticsNode)node).orElse(null);
    }

    @Override
    public VendorServerInfoNode getVendorServerInfoNode() {
        Optional<ObjectNode> component = this.getObjectComponent("VendorServerInfo");
        return component.map(node -> (VendorServerInfoNode)node).orElse(null);
    }

    @Override
    public ServerRedundancyNode getServerRedundancyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("ServerRedundancy");
        return component.map(node -> (ServerRedundancyNode)node).orElse(null);
    }

    @Override
    public NamespacesNode getNamespacesNode() {
        Optional<ObjectNode> component = this.getObjectComponent("Namespaces");
        return component.map(node -> (NamespacesNode)node).orElse(null);
    }

    @Override
    public ServerStatusDataType getServerStatus() {
        Optional<VariableNode> component = this.getVariableComponent("ServerStatus");
        return component.map(node -> (ServerStatusDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public ServerStatusNode getServerStatusNode() {
        Optional<VariableNode> component = this.getVariableComponent("ServerStatus");
        return component.map(node -> (ServerStatusNode)node).orElse(null);
    }

    @Override
    public void setServerStatus(ServerStatusDataType value) {
        this.getVariableComponent("ServerStatus").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

