/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ConditionVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ConditionType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

@UaObjectNode(typeName="0:ConditionType")
public class ConditionNode
extends BaseEventNode
implements ConditionType {
    public ConditionNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NodeId getConditionClassId() {
        Optional<NodeId> property = this.getProperty(ConditionType.CONDITION_CLASS_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getConditionClassIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_CLASS_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setConditionClassId(NodeId value) {
        this.setProperty(ConditionType.CONDITION_CLASS_ID, value);
    }

    @Override
    public LocalizedText getConditionClassName() {
        Optional<LocalizedText> property = this.getProperty(ConditionType.CONDITION_CLASS_NAME);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getConditionClassNameNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_CLASS_NAME.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setConditionClassName(LocalizedText value) {
        this.setProperty(ConditionType.CONDITION_CLASS_NAME, value);
    }

    @Override
    public String getConditionName() {
        Optional<String> property = this.getProperty(ConditionType.CONDITION_NAME);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getConditionNameNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CONDITION_NAME.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setConditionName(String value) {
        this.setProperty(ConditionType.CONDITION_NAME, value);
    }

    @Override
    public NodeId getBranchId() {
        Optional<NodeId> property = this.getProperty(ConditionType.BRANCH_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getBranchIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.BRANCH_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setBranchId(NodeId value) {
        this.setProperty(ConditionType.BRANCH_ID, value);
    }

    @Override
    public Boolean getRetain() {
        Optional<Boolean> property = this.getProperty(ConditionType.RETAIN);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getRetainNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.RETAIN.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setRetain(Boolean value) {
        this.setProperty(ConditionType.RETAIN, value);
    }

    @Override
    public String getClientUserId() {
        Optional<String> property = this.getProperty(ConditionType.CLIENT_USER_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getClientUserIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ConditionType.CLIENT_USER_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setClientUserId(String value) {
        this.setProperty(ConditionType.CLIENT_USER_ID, value);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public StatusCode getQuality() {
        Optional<VariableNode> component = this.getVariableComponent("Quality");
        return component.map(node -> (StatusCode)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public ConditionVariableNode getQualityNode() {
        Optional<VariableNode> component = this.getVariableComponent("Quality");
        return component.map(node -> (ConditionVariableNode)node).orElse(null);
    }

    @Override
    public void setQuality(StatusCode value) {
        this.getVariableComponent("Quality").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UShort getLastSeverity() {
        Optional<VariableNode> component = this.getVariableComponent("LastSeverity");
        return component.map(node -> (UShort)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public ConditionVariableNode getLastSeverityNode() {
        Optional<VariableNode> component = this.getVariableComponent("LastSeverity");
        return component.map(node -> (ConditionVariableNode)node).orElse(null);
    }

    @Override
    public void setLastSeverity(UShort value) {
        this.getVariableComponent("LastSeverity").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public LocalizedText getComment() {
        Optional<VariableNode> component = this.getVariableComponent("Comment");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public ConditionVariableNode getCommentNode() {
        Optional<VariableNode> component = this.getVariableComponent("Comment");
        return component.map(node -> (ConditionVariableNode)node).orElse(null);
    }

    @Override
    public void setComment(LocalizedText value) {
        this.getVariableComponent("Comment").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

