/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.AcknowledgeableConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ShelvedStateMachineNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AlarmConditionType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:AlarmConditionType")
public class AlarmConditionNode
extends AcknowledgeableConditionNode
implements AlarmConditionType {
    public AlarmConditionNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NodeId getInputNode() {
        Optional<NodeId> property = this.getProperty(AlarmConditionType.INPUT_NODE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getInputNodeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.INPUT_NODE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setInputNode(NodeId value) {
        this.setProperty(AlarmConditionType.INPUT_NODE, value);
    }

    @Override
    public Boolean getSuppressedOrShelved() {
        Optional<Boolean> property = this.getProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getSuppressedOrShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.SUPPRESSED_OR_SHELVED.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setSuppressedOrShelved(Boolean value) {
        this.setProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED, value);
    }

    @Override
    public Double getMaxTimeShelved() {
        Optional<Double> property = this.getProperty(AlarmConditionType.MAX_TIME_SHELVED);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getMaxTimeShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.MAX_TIME_SHELVED.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setMaxTimeShelved(Double value) {
        this.setProperty(AlarmConditionType.MAX_TIME_SHELVED, value);
    }

    @Override
    public ShelvedStateMachineNode getShelvingStateNode() {
        Optional<ObjectNode> component = this.getObjectComponent("ShelvingState");
        return component.map(node -> (ShelvedStateMachineNode)node).orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public LocalizedText getActiveState() {
        Optional<VariableNode> component = this.getVariableComponent("ActiveState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getActiveStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("ActiveState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setActiveState(LocalizedText value) {
        this.getVariableComponent("ActiveState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public LocalizedText getSuppressedState() {
        Optional<VariableNode> component = this.getVariableComponent("SuppressedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getSuppressedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("SuppressedState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setSuppressedState(LocalizedText value) {
        this.getVariableComponent("SuppressedState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

