/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;

public class X509IdentityValidator
extends AbstractIdentityValidator {
    private final Predicate<X509Certificate> predicate;

    public X509IdentityValidator(Predicate<X509Certificate> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Object validateX509Token(SecureChannel channel, Session session, X509IdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        SecurityAlgorithm algorithm;
        SecurityPolicy securityPolicy;
        ByteString clientCertificateBs = token.getCertificateData();
        X509Certificate identityCertificate = CertificateUtil.decodeCertificate(clientCertificateBs.bytesOrEmpty());
        if (tokenPolicy.getSecurityPolicyUri() != null) {
            securityPolicy = SecurityPolicy.fromUri(tokenPolicy.getSecurityPolicyUri());
            if (!tokenSignature.getAlgorithm().equals(securityPolicy.getAsymmetricSignatureAlgorithm().getUri())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by token policy");
            }
        } else {
            securityPolicy = channel.getSecurityPolicy();
            if (!tokenSignature.getAlgorithm().equals(securityPolicy.getAsymmetricSignatureAlgorithm().getUri())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by secure channel");
            }
        }
        if ((algorithm = SecurityAlgorithm.fromUri(tokenSignature.getAlgorithm())) != SecurityAlgorithm.None) {
            this.validateSignature(channel, session, tokenSignature, identityCertificate, algorithm);
        }
        if (this.predicate.test(identityCertificate)) {
            return identityCertificate;
        }
        throw new UaException(2149515264L);
    }

    private void validateSignature(SecureChannel channel, Session session, SignatureData tokenSignature, X509Certificate identityCertificate, SecurityAlgorithm algorithm) throws UaException {
        try {
            Signature signature = Signature.getInstance(algorithm.getTransformation());
            signature.initVerify(identityCertificate);
            ByteString serverCertificateBs = channel.getLocalCertificateBytes();
            ByteString lastNonceBs = session.getLastNonce();
            ByteBuffer toVerify = ByteBuffer.allocate(serverCertificateBs.length() + lastNonceBs.length());
            toVerify.put(serverCertificateBs.bytesOrEmpty());
            toVerify.put(lastNonceBs.bytesOrEmpty());
            toVerify.flip();
            signature.update(toVerify);
            if (!signature.verify(tokenSignature.getSignature().bytes())) {
                throw new UaException(2148728832L, "could not verify signature");
            }
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

